/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.api;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import java.util.Iterator;
import java.util.ServiceLoader;

public class NativeInterface {
    private static INativeInterface ACTIVE;
    private static String NAME;
    public static INativeHandle NULL;
    public static final String PROP_NATIVEINTERFACE = "de.intarsys.nativec.api.INativeInterface";

    protected static INativeInterface createNativeInterface() {
        String className = NativeInterface.getName();
        if (className == null) {
            className = System.getProperty(PROP_NATIVEINTERFACE);
        }
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                return (INativeInterface)clazz.newInstance();
            }
            catch (Exception e) {
                throw new NoClassDefFoundError(className);
            }
        }
        return NativeInterface.findNativeInterface();
    }

    protected static INativeInterface findNativeInterface() {
        ServiceLoader<INativeInterface> loader = ServiceLoader.load(INativeInterface.class);
        Iterator<INativeInterface> ps = loader.iterator();
        if (ps.hasNext()) {
            try {
                return ps.next();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized INativeInterface get() {
        if (ACTIVE == null) {
            NativeInterface.set(NativeInterface.createNativeInterface());
        }
        return ACTIVE;
    }

    public static synchronized String getName() {
        return NAME;
    }

    public static synchronized void set(INativeInterface nativeInterface) {
        if (nativeInterface == null) {
            throw new NullPointerException("no native interface available");
        }
        ACTIVE = nativeInterface;
        NULL = nativeInterface.createHandle(0L);
    }

    public static synchronized void setName(String name) {
        NAME = name;
    }
}

