/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Function;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CWideString;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

public class JnaNativeFunction
implements INativeFunction {
    private Function function;

    public JnaNativeFunction(Function function) {
        this.function = function;
    }

    protected Function getFunction() {
        return this.function;
    }

    @Override
    public <T> T invoke(Class<T> returnType, Object ... objects) {
        Pointer pointer;
        Object result;
        JnaNativeHandle handle;
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof INativeObject) {
                handle = (JnaNativeHandle)((INativeObject)object).getNativeHandle();
                objects[i] = handle == null ? null : handle.getPointer();
            } else if (object instanceof INativeHandle) {
                handle = (JnaNativeHandle)object;
                objects[i] = handle.getPointer();
            } else if (object instanceof CWideString) {
                objects[i] = new WString(((CWideString)object).getString());
            } else if (object instanceof CLong) {
                objects[i] = new NativeLong(((CLong)object).longValue());
            }
            ++i;
        }
        if (CWideString.class.isAssignableFrom(returnType)) {
            WString wstring = (WString)this.function.invoke(WString.class, objects);
            result = new CWideString(wstring.toString());
        } else if (CLong.class.isAssignableFrom(returnType)) {
            NativeLong nativeLong = (NativeLong)this.function.invoke(NativeLong.class, objects);
            result = new CLong(nativeLong.longValue());
        } else if (NativeObject.class.isAssignableFrom(returnType)) {
            pointer = (Pointer)this.function.invoke(Pointer.class, objects);
            if (pointer == null) {
                result = null;
            } else {
                handle = new JnaNativeHandle(pointer);
                INativeType type = NativeType.lookup(returnType);
                if (type == null) {
                    throw new IllegalArgumentException("no type for '" + returnType + "'");
                }
                result = type.createNative(handle);
            }
        } else {
            result = INativeHandle.class.isAssignableFrom(returnType) ? ((pointer = (Pointer)this.function.invoke(Pointer.class, objects)) == null ? null : new JnaNativeHandle(pointer)) : this.function.invoke(returnType, objects);
        }
        return (T)result;
    }
}

