/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.InternalError;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.jna.JnaNativeCallbackAlt;
import de.intarsys.nativec.jna.JnaNativeCallbackStd;
import de.intarsys.nativec.jna.JnaNativeFunction;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.jna.JnaNativeLibrary;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JnaNativeInterface
implements INativeInterface {
    private static Constructor<? extends Pointer> pointerFactory;
    private List<String> searchPaths = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader loader;
        ClassLoader classLoader = loader = JnaNativeInterface.class.getClassLoader();
        synchronized (classLoader) {
            try {
                Class.forName("com.sun.jna.Native", true, loader);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("can not load JNA");
            }
        }
        try {
            Class<?> clazz = Class.forName("com.sun.jna.FastMemory", true, loader);
            pointerFactory = clazz.getConstructor(Integer.TYPE);
        }
        catch (Exception e) {
            try {
                pointerFactory = Memory.class.getConstructor(Long.TYPE);
            }
            catch (Exception e1) {
                throw new InternalError("can not load JNA");
            }
        }
    }

    @Override
    public void addSearchPath(String path) {
        if (this.searchPaths.contains(path)) {
            return;
        }
        this.searchPaths.add(path);
    }

    @Override
    public INativeHandle allocate(int size) {
        return new JnaNativeHandle(this.createMemory(size));
    }

    @Override
    public INativeCallback createCallback(ICallback callback) {
        if (callback == null) {
            return null;
        }
        if (callback.getCallingConvention() == INativeFunction.CallingConventionStdcall) {
            return new JnaNativeCallbackAlt(callback);
        }
        if (callback.getCallingConvention() == INativeFunction.CallingConventionCdecl) {
            return new JnaNativeCallbackStd(callback);
        }
        throw new IllegalArgumentException("illegal calling convention");
    }

    @Override
    public INativeFunction createFunction(long address) {
        return this.createFunction(address, INativeFunction.CallingConventionCdecl);
    }

    @Override
    public INativeFunction createFunction(long address, Object callingConvention) {
        int callFlags;
        if (callingConvention == INativeFunction.CallingConventionCdecl) {
            callFlags = 0;
        } else if (callingConvention == INativeFunction.CallingConventionStdcall) {
            callFlags = 1;
        } else {
            throw new IllegalArgumentException("illegal calling convention");
        }
        Pointer pointer = new Pointer(address);
        Function function = Function.getFunction((Pointer)pointer, (int)callFlags);
        return new JnaNativeFunction(function);
    }

    @Override
    public INativeHandle createHandle(long address) {
        return new JnaNativeHandle(address);
    }

    @Override
    public INativeLibrary createLibrary(String name) {
        return this.createLibrary(name, INativeFunction.CallingConventionCdecl);
    }

    @Override
    public INativeLibrary createLibrary(String name, Object callingConvention) {
        HashMap<String, Object> options = new HashMap<String, Object>(2);
        if (callingConvention == INativeFunction.CallingConventionCdecl) {
            options.put("calling-convention", 0);
        } else if (callingConvention == INativeFunction.CallingConventionStdcall) {
            options.put("calling-convention", 1);
        } else {
            throw new IllegalArgumentException("illegal calling convention");
        }
        options.put("open-flags", -1);
        return new JnaNativeLibrary(this, name, options);
    }

    protected Pointer createMemory(int size) {
        try {
            Pointer p = pointerFactory.newInstance(size);
            p.clear((long)size);
            return p;
        }
        catch (Exception e) {
            throw new InternalError("can not create Pointer");
        }
    }

    protected List<String> getSearchPaths() {
        return this.searchPaths;
    }

    @Override
    public int longSize() {
        return Native.LONG_SIZE;
    }

    @Override
    public int pointerSize() {
        return Native.POINTER_SIZE;
    }

    @Override
    public int wideCharSize() {
        return 2;
    }
}

