/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArrayType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeVoid;

public class NativeArray
extends NativeObject {
    public static final NativeArrayType META = new NativeArrayType(NativeVoid.META, 0);
    private INativeObject[] values;
    private NativeArrayType type;

    static {
        NativeType.register(NativeArray.class, META);
    }

    public static NativeArray create(INativeType baseType, int size) {
        NativeArrayType type = new NativeArrayType(baseType, size);
        return new NativeArray(type);
    }

    protected NativeArray(NativeArrayType type) {
        this.type = type;
        this.allocate();
    }

    protected NativeArray(NativeArrayType type, INativeHandle handle) {
        super(handle);
        this.type = type;
    }

    public INativeType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public int getByteCount() {
        return this.type.getByteCount();
    }

    public synchronized INativeObject getNativeObject(int index) {
        INativeObject result;
        if (this.values == null) {
            this.values = new INativeObject[this.getSize()];
        }
        if ((result = this.values[index]) == null) {
            int elementOffset = index * this.type.getBaseSize();
            this.values[index] = result = this.type.getBaseType().createNative(this.handle.offset(elementOffset));
        }
        return result;
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    public int getSize() {
        return this.type.getArraySize();
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("getValue not implemented for NativeArray");
    }

    public Object getValue(int index) {
        return this.getNativeObject(index).getValue();
    }

    public void setBaseType(INativeType baseType) {
        this.type = NativeArrayType.create(baseType, this.type.getArraySize());
        this.values = null;
        this.handle.setSize(this.getByteCount());
    }

    public void setSize(int size) {
        this.type = NativeArrayType.create(this.type.getBaseType(), size);
        this.values = null;
        this.handle.setSize(this.getByteCount());
    }

    public void setValue(int index, Object value) {
        this.getNativeObject(index).setValue(value);
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("setValue not implemented for NativeArray");
    }

    @Override
    public String toNestedString() {
        return "[...]";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.getSize()) {
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

