/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeLongType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeType;

public class NativeLong
extends NativeNumber {
    public static final NativeLongType META = new NativeLongType();

    static {
        NativeType.register(NativeLong.class, META);
    }

    public static NativeLong createFromAddress(long address) {
        return (NativeLong)META.createNative(NativeTools.toHandle(address));
    }

    public NativeLong() {
        this.allocate();
    }

    protected NativeLong(INativeHandle handle) {
        super(handle);
    }

    public NativeLong(long value) {
        this.allocate();
        this.setValue(value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return new Long(this.longValue());
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.handle.getCLong(0);
    }

    public void setValue(long value) {
        this.handle.setCLong(0, value);
    }

    @Override
    public void setValue(Object value) {
        this.setValue(((Number)value).longValue());
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    public String toString() {
        if (this.getNativeHandle() == null) {
            return "nope - no handle";
        }
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.longValue());
    }
}

