/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeReferenceType;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeVoid;

public class NativeReference<T extends INativeObject>
extends NativeObject {
    public static final NativeReferenceType META = new NativeReferenceType(NativeVoid.META);
    private INativeHandle dereferenceHandle;
    private T dereferenced;
    private NativeReferenceType type;

    static {
        NativeType.register(NativeReference.class, META);
    }

    public static <U extends INativeObject> NativeReference<U> create(INativeType baseType) {
        NativeReferenceType type = new NativeReferenceType(baseType);
        return new NativeReference(type);
    }

    protected NativeReference(NativeReferenceType type) {
        this.type = type;
        this.allocate();
    }

    protected NativeReference(NativeReferenceType type, INativeHandle handle) {
        super(handle);
        this.type = type;
        handle.setSize(this.getByteCount());
    }

    public INativeType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public int getByteCount() {
        return NativeInterface.get().pointerSize();
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    public long getReferencedAddress() {
        return this.getNativeHandle(0).getAddress();
    }

    public synchronized T getValue() {
        this.dereferenceHandle = this.handle.getNativeHandle(0);
        if (this.dereferenced == null || !this.dereferenced.getNativeHandle().equals(this.dereferenceHandle)) {
            this.dereferenced = this.type.getBaseType().createNative(this.dereferenceHandle);
        }
        return this.dereferenced;
    }

    public void setBaseType(INativeType baseType) {
        this.type = NativeReferenceType.create(baseType);
        this.dereferenceHandle = null;
        this.dereferenced = null;
    }

    @Override
    public synchronized void setValue(Object value) {
        if (value instanceof INativeObject) {
            INativeObject nativeObject = (INativeObject)value;
            INativeHandle valueHandle = nativeObject.getNativeHandle();
            this.handle.setNativeHandle(0, valueHandle);
            this.dereferenceHandle = valueHandle;
            this.dereferenced = nativeObject;
        } else if (value instanceof INativeHandle) {
            INativeHandle valueHandle = (INativeHandle)value;
            this.handle.setNativeHandle(0, valueHandle);
            this.dereferenceHandle = valueHandle;
            this.dereferenced = null;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        if (this.handle == null) {
            return "Ref to null";
        }
        return "Ref to " + this.getReferencedAddress();
    }
}

