/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArrayType;
import de.intarsys.nativec.type.NativeReferenceType;
import java.util.HashMap;
import java.util.Map;

public abstract class NativeType
implements INativeType {
    private static Map<Class<?>, INativeType> metaClasses = new HashMap();

    public static synchronized INativeType lookup(Class<?> clazz) {
        INativeType result = metaClasses.get(clazz);
        if (result == null) {
            clazz.getClasses();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = NativeType.class.getClassLoader();
            }
            try {
                Class.forName(clazz.getName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            result = metaClasses.get(clazz);
        }
        return result;
    }

    public static synchronized void register(Class<?> clazz, INativeType type) {
        metaClasses.put(clazz, type);
    }

    protected NativeType() {
    }

    protected NativeType(Class<?> instanceClass) {
        NativeType.register(instanceClass, this);
    }

    @Override
    public INativeType Array(int size) {
        return new NativeArrayType(this, size);
    }

    @Override
    public INativeObject createNative(INativeHandle handle) {
        throw new IllegalStateException("meta constructor missing");
    }

    @Override
    public INativeObject createNative(Object value) {
        throw new IllegalStateException("meta constructor missing");
    }

    @Override
    public int getByteCount() {
        return 0;
    }

    @Override
    public INativeType Ref() {
        return new NativeReferenceType(this);
    }
}

