/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.authenticate.PasswordTools;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.PBAES128Cryptdec;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SecretMemory {
    private final transient ICryptdec cryptdec;
    private final transient Map<Object, byte[]> memory = new HashMap<Object, byte[]>();

    private static ICryptdec createSessionCryptdec() {
        char[] cArray = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            cArray = PasswordTools.createPassword(16);
            byArray = ByteArrayTools.createRandomBytes(8);
            byArray2 = ByteArrayTools.createRandomBytes(16);
            PBAES128Cryptdec pBAES128Cryptdec = new PBAES128Cryptdec("session", byArray2, cArray, byArray, 19);
            return pBAES128Cryptdec;
        }
        catch (Exception exception) {
            throw new IllegalStateException("cryptec initialization error", exception);
        }
        finally {
            Arrays.fill(cArray, ' ');
            Arrays.fill(byArray, (byte)0);
            Arrays.fill(byArray2, (byte)0);
        }
    }

    public SecretMemory() {
        this(SecretMemory.createSessionCryptdec());
    }

    public SecretMemory(ICryptdec iCryptdec) {
        this.cryptdec = iCryptdec;
    }

    public void clear() {
        this.memory.clear();
    }

    public byte[] getBytes(Object object) throws IOException {
        byte[] byArray = this.memory.get(object);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.cryptdec.decrypt(byArray);
        return byArray2;
    }

    public char[] getCharacters(Object object) throws IOException {
        byte[] byArray = this.memory.get(object);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.cryptdec.decrypt(byArray);
        char[] cArray = new char[byArray2.length / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c;
            cArray[n2] = c = (char)(((byArray2[n++] & 0xFF) << 8) + (byArray2[n++] & 0xFF));
            ++n2;
        }
        return cArray;
    }

    public Object put(byte[] byArray) throws IOException {
        byte[] byArray2 = this.cryptdec.encrypt(byArray);
        Object object = new Object();
        this.memory.put(object, byArray2);
        return object;
    }

    public Object put(char[] cArray) throws IOException {
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            byArray[n++] = (byte)(c >> 8);
            byArray[n++] = (byte)c;
            ++n2;
        }
        byte[] byArray2 = this.cryptdec.encrypt(byArray);
        Object object = new Object();
        this.memory.put(object, byArray2);
        return object;
    }

    public void remove(Object object) {
        this.memory.remove(object);
    }
}

