/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.PACKAGE;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstrumentTools {
    private static final Logger Log = PACKAGE.Log;

    public static IExtension getLastExtension(IInstrumentRegistry registry, String extensionPointId) {
        IExtensionPoint ep = registry.lookupExtensionPoint(extensionPointId);
        if (ep == null) {
            Log.log(Level.WARNING, "extension point '" + extensionPointId + "' not found");
            return null;
        }
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length > 0) {
            return extensions[extensions.length - 1];
        }
        return null;
    }

    public static IExtension getOrCreateExtension(IInstrument provider, String extensionPointId, String id) throws ObjectCreationException, InstrumentRegistryException {
        IExtension[] extensions = provider.getExtensions();
        IExtension targetExtension = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPoint().getId().equals(extensionPointId) && (id == null || extension.getId().equals(id))) {
                targetExtension = extension;
                break;
            }
            ++n2;
        }
        if (targetExtension == null) {
            targetExtension = provider.createExtension(extensionPointId, id);
            IInstrument prerequisiteProvider = provider.getInstrumentRegistry().lookupExtensionPoint(extensionPointId).getProvider();
            provider.addPrerequisite(prerequisiteProvider, "skip");
            provider.registerExtension(targetExtension);
        }
        return targetExtension;
    }

    public static void installExtensions(IInstrumentRegistry registry, String point, IExtensionPointHandler functor) throws InstrumentRegistryException {
        IExtensionPoint extensionPoint = registry.lookupExtensionPoint(point);
        if (extensionPoint == null) {
            Log.log(Level.WARNING, "extension point '" + point + "' not found");
            return;
        }
        functor.setExtensionPoint(extensionPoint);
        functor.install();
    }

    public static boolean isPrerequisiteImplied(IInstrument instrument, IInstrument requiredInstrument) {
        if (requiredInstrument == instrument) {
            return true;
        }
        IInstrumentPrerequisite[] iInstrumentPrerequisiteArray = instrument.getPrerequisites();
        int n = iInstrumentPrerequisiteArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInstrumentPrerequisite prerequisite = iInstrumentPrerequisiteArray[n2];
            IInstrument tempInstrument = prerequisite.getInstrument();
            if (InstrumentTools.isPrerequisiteImplied(tempInstrument, requiredInstrument)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IExtension lookupDefiningExtension(IExtensionPoint extensionPoint, Object object) {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            List<ExtensionOperation> attachments = extension.getOperations();
            for (ExtensionOperation attachment : attachments) {
                if (!attachment.isInsert() || attachment.getObject() != object) continue;
                return extension;
            }
            ++n2;
        }
        return null;
    }

    public static IInstrument lookupInstrument(IInstrumentRegistry registry, String instrumentId) {
        IInstrument iInstrument = registry.lookupInstrument(instrumentId);
        if (iInstrument == null) {
            return null;
        }
        return iInstrument.getState().isStarted() ? iInstrument : null;
    }

    public static IInstrument lookupOrCreateInstrument(IInstrumentRegistry registry, String instrumentId, IInstrumentStore store) throws ObjectCreationException, InstrumentRegistryException {
        String tempId = instrumentId;
        int counter = 1;
        IInstrument iInstrument = registry.lookupInstrument(tempId);
        while (iInstrument != null && !iInstrument.getState().isStarted()) {
            tempId = String.valueOf(instrumentId) + "." + counter++;
            iInstrument = registry.lookupInstrument(tempId);
        }
        if (iInstrument == null) {
            iInstrument = registry.createInstrument(tempId, store);
            registry.registerInstrument(iInstrument);
        }
        return iInstrument;
    }

    public static IExtension objectDelete(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalStateException("provider can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachDelete(target);
        IExtension tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target);
        if (tempExtension != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            provider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static IExtension objectInsert(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IExtension tempExtension;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalStateException("provide can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachInsert(target);
        if (target instanceof IContextSupport) {
            try {
                ((IContextSupport)target).setContext(targetExtension.getProvider());
            }
            catch (ConfigurationException e) {
                throw new InstrumentRegistryException(e.getLocalizedMessage(), e);
            }
        }
        if ((tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target)) != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            targetProvider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static IExtension objectUpdate(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalStateException("provide can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachUpdate(target);
        IExtension tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target);
        if (tempExtension != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            provider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static void uninstallExtensions(IInstrumentRegistry registry, String point, IExtensionPointHandler functor) throws InstrumentRegistryException {
        IExtensionPoint extensionPoint = registry.lookupExtensionPoint(point);
        if (extensionPoint == null) {
            Log.log(Level.WARNING, "extension point '" + point + "' not found");
            return;
        }
        functor.uninstall();
    }
}

