/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.impl.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensionPointHandlerAdapter
implements IExtensionPointHandler {
    private static final Logger Log = PACKAGE.Log;
    private final Attribute ATTR_INSTALLED = new Attribute("installed");
    private IExtensionPoint extensionPoint;
    private boolean installed = false;

    protected List<ExtensionOperation> basicGetAttachments(IExtension extension) {
        return extension.getOperations();
    }

    protected void basicInstall() throws InstrumentRegistryException {
        IExtension[] extensions = this.extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                this.install(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError("Error", String.valueOf(StringTools.safeString(extension)) + " unexpected installation error", t, 0);
            }
            ++i;
        }
    }

    protected void basicInstall(IExtension extension) {
        IElement root = extension.getElement();
        Iterator<IElement> it = root.elementIterator();
        while (it.hasNext()) {
            IElement childElement = it.next();
            try {
                Object object;
                String op = childElement.attributeValue("_op", null);
                if (op == null || "insert".equals(op)) {
                    object = this.basicInstallInsert(extension, childElement);
                    if (object == null) continue;
                    extension.attachInsert(object);
                    continue;
                }
                if ("update".equals(op)) {
                    object = this.basicInstallUpdate(extension, childElement);
                    if (object == null) continue;
                    extension.attachUpdate(object);
                    continue;
                }
                if ("delete".equals(op)) {
                    object = this.basicInstallDelete(extension, childElement);
                    if (object == null) continue;
                    extension.attachDelete(object);
                    continue;
                }
                Reporter.get().reportError("Error", String.valueOf(StringTools.safeString(extension)) + " element " + childElement.getName() + " unsupported operation " + op, null, 0);
            }
            catch (Throwable t) {
                Reporter.get().reportError("Error", String.valueOf(StringTools.safeString(extension)) + " element " + childElement.getName() + " unexpected installation error", t, 0);
            }
        }
    }

    protected Object basicInstallDelete(IExtension extension, IElement element) {
        Log.log(Level.WARNING, String.valueOf(StringTools.safeString(extension)) + " delete not supported for element '" + element.getName() + "'");
        return null;
    }

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        Log.log(Level.WARNING, String.valueOf(StringTools.safeString(extension)) + " unknown element '" + element.getName() + "'");
        return null;
    }

    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        Log.log(Level.WARNING, String.valueOf(StringTools.safeString(extension)) + " update not supported for element '" + element.getName() + "'");
        return null;
    }

    protected void basicUninstall() {
        IExtension[] extensions = this.getExtensionPoint().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                this.uninstall(extension);
            }
            catch (Throwable t) {
                Reporter.get().reportError("Error", String.valueOf(StringTools.safeString(extension)) + " unexpected uninstall error", t, 0);
            }
            ++i;
        }
    }

    protected void basicUninstall(IExtension extension) {
        IElement root = extension.getElement();
        Iterator<IElement> it = root.elementIterator();
        while (it.hasNext()) {
            IElement childElement = it.next();
            try {
                this.basicUninstall(extension, childElement);
            }
            catch (Throwable t) {
                Reporter.get().reportError("Error", String.valueOf(StringTools.safeString(extension)) + " element " + childElement.getName() + " unexpected uninstallation error", t, 0);
            }
        }
    }

    protected void basicUninstall(IExtension extension, IElement element) {
    }

    @Override
    public IExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    protected List<Object> getManagedObjects(IExtension extension) {
        return new ArrayList<Object>();
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install() throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (this.isInstalled()) {
                return;
            }
            this.setInstalled(true);
            this.basicInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void install(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (extension.getAttribute(this.ATTR_INSTALLED) != null) {
                return;
            }
            extension.setAttribute(this.ATTR_INSTALLED, Boolean.TRUE);
            this.basicInstall(extension);
        }
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    protected void log(Logger log, Level level, IExtension extension, IElement element, String msg, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTools.safeString(extension));
        sb.append(" element '");
        sb.append(element.getName());
        sb.append("': ");
        sb.append(msg);
        log.log(level, sb.toString(), e);
    }

    protected void log(Logger log, Level level, IExtension extension, String msg, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTools.safeString(extension));
        sb.append(": ");
        sb.append(msg);
        log.log(level, sb.toString(), e);
    }

    protected Object performFunctor(IExtension extension, IElement element) throws ObjectCreationException, FunctorInvocationException {
        IFunctor functor = ElementTools.createFunctor(extension.getProvider(), element, null, extension.getProvider());
        Args args = Args.create();
        args.put("installer", (Object)this);
        args.put("extension", (Object)this);
        args.put("element", (Object)this);
        FunctorCall call = new FunctorCall(extension, args);
        return functor.perform(call);
    }

    protected Object performNestedFunctor(IExtension extension, IElement element, String functorElementName) throws ObjectCreationException, FunctorInvocationException {
        IFunctor functor = ElementTools.createFunctor(extension.getProvider(), element.element(functorElementName), null, extension.getProvider());
        Args args = Args.create();
        args.put("installer", (Object)this);
        args.put("extension", (Object)this);
        args.put("element", (Object)this);
        FunctorCall call = new FunctorCall(extension, args);
        return functor.perform(call);
    }

    @Override
    public final void setExtensionPoint(IExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
        this.initialize();
    }

    protected void setInstalled(boolean installed) {
        this.installed = installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall() throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (this.getExtensionPoint() == null || this.getExtensionPoint().getAttribute(this.ATTR_INSTALLED) == null) {
                return;
            }
            this.extensionPoint = null;
            this.getExtensionPoint().setAttribute(this.ATTR_INSTALLED, null);
            this.basicUninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstall(IExtension extension) throws InstrumentRegistryException {
        ExtensionPointHandlerAdapter extensionPointHandlerAdapter = this;
        synchronized (extensionPointHandlerAdapter) {
            if (extension.getAttribute(this.ATTR_INSTALLED) == null) {
                return;
            }
            extension.setAttribute(this.ATTR_INSTALLED, null);
            this.basicUninstall(extension);
        }
    }

    @Override
    public void update(IExtension extension) throws InstrumentRegistryException {
        List<ExtensionOperation> attachments = this.basicGetAttachments(extension);
        extension.getElement().elementsClear();
        for (ExtensionOperation attachment : attachments) {
            try {
                attachment.perform(extension);
            }
            catch (Exception e) {
                this.log(Log, Level.WARNING, extension, e.getLocalizedMessage(), e);
            }
        }
    }
}

