/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.State;
import de.intarsys.claptz.StateNew;
import de.intarsys.claptz.impl.ExtensionObjectDelete;
import de.intarsys.claptz.impl.ExtensionObjectInsert;
import de.intarsys.claptz.impl.ExtensionObjectUpdate;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public class StandardExtension {
    private final Facade facade = new Facade();
    private String extensionPointId;
    private IElement element;
    private final StandardInstrument provider;
    private StandardExtensionPoint extensionPoint;
    private String id;
    private State state = new StateNew("");
    private final AttributeMap attributes = new AttributeMap();
    private String ifdef;
    private String ifnotdef;
    private String absentAction = null;
    private List<ExtensionOperation> operations = new ArrayList<ExtensionOperation>();

    public StandardExtension(StandardInstrument provider, String extensionPointId, String id) {
        if (extensionPointId == null) {
            throw new NullPointerException("extensionPointId can't be null");
        }
        this.provider = provider;
        this.extensionPointId = extensionPointId;
        this.id = id;
    }

    public void attachObjectDelete(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectDelete(target));
        } else if (!tempOperation.isDelete()) {
            if (tempOperation.isInsert()) {
                this.operations.remove(tempOperation);
            } else if (tempOperation.isUpdate()) {
                this.operations.remove(tempOperation);
                this.operations.add(new ExtensionObjectDelete(target));
            }
        }
    }

    public void attachObjectInsert(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectInsert(target));
        } else if (tempOperation.isDelete()) {
            this.operations.remove(tempOperation);
            this.operations.add(new ExtensionObjectInsert(target));
        } else if (!tempOperation.isInsert() && tempOperation.isUpdate()) {
            this.operations.remove(tempOperation);
            this.operations.add(new ExtensionObjectInsert(target));
        }
    }

    public void attachObjectUpdate(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectUpdate(target));
        } else if (tempOperation.isDelete()) {
            this.operations.remove(tempOperation);
            this.operations.add(new ExtensionObjectUpdate(target));
        } else if (!tempOperation.isInsert()) {
            tempOperation.isUpdate();
        }
    }

    protected ExtensionOperation findOperation(Object target) {
        for (ExtensionOperation extensionOperation : this.getOperations()) {
            if (extensionOperation.getObject() != target) continue;
            return extensionOperation;
        }
        return null;
    }

    public String getAbsentAction() {
        return this.absentAction;
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public IElement getElement() {
        return this.element;
    }

    protected StandardExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    protected IExtensionPoint getExtensionPointFacade() {
        return this.extensionPoint == null ? null : this.extensionPoint.getFacade();
    }

    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    public Facade getFacade() {
        return this.facade;
    }

    public String getId() {
        return this.id;
    }

    public String getIfdef() {
        return this.ifdef;
    }

    public String getIfnotdef() {
        return this.ifnotdef;
    }

    public List<ExtensionOperation> getOperations() {
        return this.operations;
    }

    public StandardInstrument getProvider() {
        return this.provider;
    }

    public State getState() {
        return this.state;
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public void setAbsentAction(String absentAction) {
        this.absentAction = absentAction;
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setElement(IElement element) {
        this.element = element;
    }

    protected void setExtensionPoint(StandardExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public void setIfdef(String ifdef) {
        this.ifdef = ifdef;
    }

    public void setIfnotdef(String ifnotdef) {
        this.ifnotdef = ifnotdef;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String toString() {
        try {
            return "IExtension to '" + this.getExtensionPointId() + "' by " + StringTools.safeString(this.getProvider());
        }
        catch (RuntimeException e) {
            return "<unprintable IExtension>";
        }
    }

    public class Facade
    implements IExtension {
        @Override
        public void attachDelete(Object target) {
            StandardExtension.this.attachObjectDelete(target);
        }

        @Override
        public void attachInsert(Object target) {
            StandardExtension.this.attachObjectInsert(target);
        }

        @Override
        public void attachUpdate(Object target) {
            StandardExtension.this.attachObjectUpdate(target);
        }

        public String getAbsentAction() {
            return StandardExtension.this.getAbsentAction();
        }

        @Override
        public List<ExtensionOperation> getOperations() {
            return StandardExtension.this.getOperations();
        }

        @Override
        public Object getAttribute(Object key) {
            return StandardExtension.this.getAttribute(key);
        }

        @Override
        public IElement getElement() {
            return StandardExtension.this.getElement();
        }

        @Override
        public IExtensionPoint getExtensionPoint() {
            return StandardExtension.this.getExtensionPointFacade();
        }

        public String getExtensionPointId() {
            return StandardExtension.this.getExtensionPointId();
        }

        @Override
        public String getId() {
            return StandardExtension.this.getId();
        }

        public String getIfdef() {
            return StandardExtension.this.getIfdef();
        }

        public String getIfnotdef() {
            return StandardExtension.this.getIfnotdef();
        }

        protected StandardExtension getOwner() {
            return StandardExtension.this;
        }

        @Override
        public IInstrument getProvider() {
            return StandardExtension.this.getProvider().getFacade();
        }

        @Override
        public Object removeAttribute(Object key) {
            return StandardExtension.this.removeAttribute(key);
        }

        @Override
        public Object setAttribute(Object key, Object value) {
            return StandardExtension.this.setAttribute(key, value);
        }
    }
}

