/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardExtension;
import de.intarsys.tools.attribute.AttributeMap;
import java.util.ArrayList;
import java.util.List;

public class StandardExtensionPoint {
    public static final Object ATTR_EXTENSIONS = new Object();
    private final Facade facade = new Facade();
    private final AttributeMap attributes = new AttributeMap();
    private List<StandardExtension> extensions = new ArrayList<StandardExtension>();
    private final String id;
    private IExtensionPointHandler installer;
    private final IInstrument provider;

    public StandardExtensionPoint(IInstrument provider, String id) {
        this.provider = provider;
        this.id = id;
    }

    protected Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    protected IExtension[] getExtensionFacades() {
        IExtension[] result = new IExtension[this.extensions.size()];
        int i = 0;
        for (StandardExtension current : this.extensions) {
            result[i] = current.getFacade();
            ++i;
        }
        return result;
    }

    public Facade getFacade() {
        return this.facade;
    }

    public String getId() {
        return this.id;
    }

    public IExtensionPointHandler getInstaller() {
        return this.installer;
    }

    public IInstrument getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerExtension(StandardExtension extension) throws InstrumentRegistryException {
        StandardExtensionPoint standardExtensionPoint = this;
        synchronized (standardExtensionPoint) {
            this.extensions.add(extension);
            extension.setExtensionPoint(this);
        }
        if (this.getInstaller() != null && this.getInstaller().isInstalled()) {
            this.getInstaller().install(extension.getFacade());
        }
    }

    protected Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    protected Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setInstaller(IExtensionPointHandler installer) {
        this.installer = installer;
    }

    public String toString() {
        try {
            return "IExtensionPoint '" + this.getId() + "' by " + this.getProvider();
        }
        catch (RuntimeException e) {
            return "<unprintable extension point>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterExtension(StandardExtension extension) throws InstrumentRegistryException {
        StandardExtensionPoint standardExtensionPoint = this;
        synchronized (standardExtensionPoint) {
            this.extensions.remove(extension);
        }
        if (this.getInstaller() != null && this.getInstaller().isInstalled()) {
            this.getInstaller().uninstall(extension.getFacade());
        }
    }

    public class Facade
    implements IExtensionPoint {
        @Override
        public Object getAttribute(Object key) {
            return StandardExtensionPoint.this.getAttribute(key);
        }

        @Override
        public IExtension[] getExtensions() {
            return StandardExtensionPoint.this.getExtensionFacades();
        }

        @Override
        public String getId() {
            return StandardExtensionPoint.this.getId();
        }

        @Override
        public IExtensionPointHandler getInstaller() {
            return StandardExtensionPoint.this.getInstaller();
        }

        protected StandardExtensionPoint getOwner() {
            return StandardExtensionPoint.this;
        }

        @Override
        public IInstrument getProvider() {
            return StandardExtensionPoint.this.getProvider();
        }

        @Override
        public Object removeAttribute(Object key) {
            return StandardExtensionPoint.this.removeAttribute(key);
        }

        @Override
        public Object setAttribute(Object key, Object value) {
            return StandardExtensionPoint.this.setAttribute(key, value);
        }
    }
}

