/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentException;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentResolver;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.State;
import de.intarsys.claptz.StateExcluded;
import de.intarsys.claptz.StateFailed;
import de.intarsys.claptz.StateNew;
import de.intarsys.claptz.StateStarted;
import de.intarsys.claptz.StateStopped;
import de.intarsys.claptz.impl.PACKAGE;
import de.intarsys.claptz.impl.StandardExtension;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrumentClassLoader;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.MessageBundleMessageResolver;
import de.intarsys.tools.expression.MessageBundleStringResolver;
import de.intarsys.tools.expression.NLSMessageResolver;
import de.intarsys.tools.expression.NLSStringResolver;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.message.MessageBundleTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardInstrument
implements IAttributeSupport,
IElementConfigurable {
    private final IInstrumentStore store;
    private static final Logger Log = PACKAGE.Log;
    public static final String META_DEFINITION = "instrument.xml";
    public static final String META_DIRECTORY = "INSTRUMENT-INF";
    private static final MessageBundle Msg = PACKAGE.Messages;
    private final AttributeMap attributes = new AttributeMap();
    private File baseDir;
    private String bundleName;
    private IInstrumentPrerequisite[] cachedPrerequisites;
    private ClassLoader classLoader;
    private final List<StandardExtension> extensions = new ArrayList<StandardExtension>();
    private final IInstrument facade = new Facade();
    private String id;
    private MessageBundle messageBundle;
    private final Map<String, String> metaInfo = new HashMap<String, String>();
    private final List<StandardInstrumentPrerequisite> prerequisites = new ArrayList<StandardInstrumentPrerequisite>();
    private final StandardInstrumentRegistry registry;
    private State state = new StateNew("");
    private String ifdef;
    private String ifnotdef;
    public static final boolean CHECK_VISIBILITY = false;
    private MapResolver expressionEvaluator;
    public static final String ACTION_DEFAULT = null;
    public static final String ACTION_FAIL = "fail";
    public static final String ACTION_IGNORE = "ignore";
    public static final String ACTION_SKIP = "skip";

    public StandardInstrument(StandardInstrumentRegistry registry, IInstrumentStore store) {
        this.registry = registry;
        this.store = store;
    }

    protected void addPrerequisite(IInstrument prerequisite, String absentAction) {
        StandardInstrumentPrerequisite tempPrerequisite = new StandardInstrumentPrerequisite(this);
        tempPrerequisite.setAbsentAction(absentAction);
        tempPrerequisite.setInstrumentId(prerequisite.getId());
        if (!InstrumentTools.isPrerequisiteImplied(this.getFacade(), prerequisite)) {
            this.addPrerequisite(tempPrerequisite);
        }
    }

    protected void addPrerequisite(StandardInstrumentPrerequisite prerequisite) {
        this.prerequisites.add(prerequisite);
        this.cachedPrerequisites = null;
    }

    protected List<StandardInstrumentPrerequisite> basicGetPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.configureInstrument(element);
        IElement eRequires = element.element("requires");
        if (eRequires != null) {
            this.configurePrerequisistes(eRequires);
        }
        Iterator<IElement> itExtension = element.elementIterator("extension");
        while (itExtension.hasNext()) {
            IElement eExtension = itExtension.next();
            this.configureExtension(eExtension);
        }
    }

    protected void configureExtension(IElement eExtension) throws ConfigurationException {
        String absent;
        String ifnotdef;
        String point = eExtension.attributeValue("point", null);
        if (point == null) {
            throw new ConfigurationException("<extension/> must define 'point' attribute");
        }
        String id = eExtension.attributeValue("id", null);
        StandardExtension extension = new StandardExtension(this, point, id);
        String ifdef = eExtension.attributeValue("ifdef", null);
        if (!StringTools.isEmpty(ifdef)) {
            extension.setIfdef(ifdef);
        }
        if (!StringTools.isEmpty(ifnotdef = eExtension.attributeValue("ifnotdef", null))) {
            extension.setIfnotdef(ifnotdef);
        }
        if (!StringTools.isEmpty(absent = eExtension.attributeValue("absent", null))) {
            extension.setAbsentAction(absent);
        }
        extension.setElement(eExtension);
        try {
            this.registerExtension(extension);
        }
        catch (InstrumentRegistryException e) {
            throw new ConfigurationException(e);
        }
    }

    protected void configureInstrument(IElement element) throws ConfigurationException {
        String ifnotdef;
        String ifdef;
        String metaVersion;
        String id = element.attributeValue("id", null);
        if (id == null) {
            throw new ConfigurationException(Msg.getString("StandardInstrument.ExMustHaveID"));
        }
        this.setId(id);
        String metaName = element.attributeValue("name", null);
        if (metaName != null) {
            this.setMetaInfo("name", metaName);
        }
        String bundleName = element.attributeValue("bundle", String.valueOf(this.getId()) + ".messages");
        this.setMessageBundleName(bundleName);
        this.expressionEvaluator.put("bundlestr", new MessageBundleStringResolver(this.getMessageBundle()));
        this.expressionEvaluator.put("bundlemsg", new MessageBundleMessageResolver(this.getMessageBundle()));
        String metaVendor = element.attributeValue("vendor", null);
        if (metaVendor != null) {
            this.setMetaInfo("vendor", metaVendor);
        }
        if ((metaVersion = element.attributeValue("version", null)) != null) {
            this.setMetaInfo("version", metaVersion);
        }
        if (!StringTools.isEmpty(ifdef = element.attributeValue("ifdef", null))) {
            this.setIfdef(ifdef);
        }
        if (!StringTools.isEmpty(ifnotdef = element.attributeValue("ifnotdef", null))) {
            this.setIfnotdef(ifnotdef);
        }
    }

    protected void configurePrerequisiste(IElement element) {
        String ifnotdef;
        StandardInstrumentPrerequisite prerequisite = new StandardInstrumentPrerequisite(this);
        boolean optional = Boolean.valueOf(element.attributeValue("optional", null));
        if (optional) {
            prerequisite.setAbsentAction(ACTION_IGNORE);
        } else {
            prerequisite.setAbsentAction(element.attributeValue("absent", null));
        }
        prerequisite.setInstrumentId(element.attributeValue("instrument", null));
        String ifdef = element.attributeValue("ifdef", null);
        if (!StringTools.isEmpty(ifdef)) {
            prerequisite.setIfdef(ifdef);
        }
        if (!StringTools.isEmpty(ifnotdef = element.attributeValue("ifnotdef", null))) {
            prerequisite.setIfnotdef(ifnotdef);
        }
        this.addPrerequisite(prerequisite);
    }

    protected void configurePrerequisistes(IElement element) {
        Iterator<IElement> itExtension = element.elementIterator("prerequisite");
        while (itExtension.hasNext()) {
            IElement eExtension = itExtension.next();
            this.configurePrerequisiste(eExtension);
        }
    }

    protected ClassLoader createClassLoader() {
        ClassLoader parentLoader = this.getParentLoader();
        ClassLoader result = StandardInstrumentClassLoader.create(this, parentLoader);
        return result;
    }

    protected MapResolver createExpressionEvaluator() {
        MapResolver result = new MapResolver(true);
        result.put("instrument", new InstrumentResolver(this.getFacade()));
        result.put("nlsstr", new NLSStringResolver(this.getClassLoader()));
        result.put("nlsmsg", new NLSMessageResolver(this.getClassLoader()));
        return result;
    }

    public IExtension createExtension(String extensionPointId, String id) {
        StandardExtension targetExtension = new StandardExtension(this, extensionPointId, id);
        IElement extensionElement = ElementFactory.get().createElement("extension");
        IDocument tempDocument = ElementFactory.get().createDocument();
        ((IStringEvaluatorAccess)((Object)tempDocument)).setStringEvaluator(this.getExpressionEvaluator());
        tempDocument.setRootElement(extensionElement);
        targetExtension.setElement(extensionElement);
        extensionElement.setAttributeValue("point", targetExtension.getExtensionPointId());
        extensionElement.setAttributeValue("id", targetExtension.getId());
        return targetExtension.getFacade();
    }

    protected void flush() throws IOException {
        if (this.getStore() != null) {
            this.getStore().flush(this);
        }
    }

    @Override
    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    public String getDescription() {
        return Msg.getString("StandardInstrument.Description", this.getId(), this.getBaseDir().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStringEvaluator getExpressionEvaluator() {
        StandardInstrument standardInstrument = this;
        synchronized (standardInstrument) {
            if (this.expressionEvaluator == null) {
                this.expressionEvaluator = this.createExpressionEvaluator();
            }
            return this.expressionEvaluator;
        }
    }

    protected IExtension[] getExtensionFacades() {
        IExtension[] result = new IExtension[this.extensions.size()];
        int i = 0;
        for (StandardExtension current : this.extensions) {
            result[i] = current.getFacade();
            ++i;
        }
        return result;
    }

    public List<StandardExtension> getExtensions() {
        return this.extensions;
    }

    public IInstrument getFacade() {
        return this.facade;
    }

    public String getId() {
        return this.id;
    }

    public String getIfdef() {
        return this.ifdef;
    }

    public String getIfnotdef() {
        return this.ifnotdef;
    }

    public StandardInstrumentRegistry getInstrumentRegistry() {
        return this.registry;
    }

    public MessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            this.messageBundle = MessageBundleTools.getMessageBundle(this.getMessageBundleName(), this.getClassLoader());
        }
        return this.messageBundle;
    }

    public String getMessageBundleName() {
        return this.bundleName;
    }

    public String getMetaInfo(String name) {
        return this.metaInfo.get(name);
    }

    protected ClassLoader getParentLoader() {
        return this.getRegistry().getClassLoader();
    }

    protected IInstrumentPrerequisite[] getPrerequisiteFacades() {
        if (this.cachedPrerequisites == null) {
            this.cachedPrerequisites = new IInstrumentPrerequisite[this.prerequisites.size()];
            int i = 0;
            for (StandardInstrumentPrerequisite prerequisite : this.prerequisites) {
                this.cachedPrerequisites[i] = prerequisite.getFacade();
                ++i;
            }
        }
        return this.cachedPrerequisites;
    }

    public List<StandardInstrumentPrerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public File getProfileDir() {
        return FileEnvironment.get().getProfileDir();
    }

    protected StandardInstrumentRegistry getRegistry() {
        return this.registry;
    }

    protected State getState() {
        return this.state;
    }

    public IInstrumentStore getStore() {
        return this.store;
    }

    public File getTempDir() {
        return FileEnvironment.get().getTempDir();
    }

    public File getWorkingDir() {
        return FileEnvironment.get().getWorkingDir();
    }

    protected boolean isCheckVisibility(StandardExtension extension) {
        IInstrument provider = extension.getExtensionPoint().getProvider();
        return InstrumentTools.isPrerequisiteImplied(this.getFacade(), provider);
    }

    public void registerExtension(StandardExtension extension) throws InstrumentRegistryException {
        this.extensions.add(extension);
        if (this.getState().isStarted()) {
            this.startExtension(extension);
        }
    }

    @Override
    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void removePrerequisite(IInstrument prerequisite) {
    }

    @Override
    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setId(String name) {
        this.id = name;
        this.setMetaInfo("id", name);
    }

    public void setIfdef(String ifdef) {
        this.ifdef = ifdef;
    }

    public void setIfnotdef(String ifnotdef) {
        this.ifnotdef = ifnotdef;
    }

    public void setMessageBundle(MessageBundle bundle) {
        this.messageBundle = bundle;
    }

    public void setMessageBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setMetaInfo(String name, String value) {
        this.metaInfo.put(name, value);
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void start() {
        if (this.state.isStarted()) {
            return;
        }
        try {
            this.state = new StateStarted("started");
            this.startLocal();
        }
        catch (RuntimeException e) {
            this.state = new StateFailed(e.getLocalizedMessage());
            throw e;
        }
    }

    protected void startExtension(StandardExtension extension) throws InstrumentRegistryException {
        if (!this.registry.ppIsDefined(extension.getIfdef()) || !this.registry.ppIsNotDefined(extension.getIfnotdef())) {
            Log.log(Level.FINE, "exclude extension '" + StringTools.safeString(extension));
            return;
        }
        StandardExtensionPoint extensionPoint = this.getRegistry().lookupExtensionPoint(extension.getExtensionPointId());
        if (extensionPoint == null) {
            String action = extension.getAbsentAction();
            String reason = "missing extensionpoint '" + extension.getExtensionPointId() + "'";
            if (action == ACTION_DEFAULT || action.equals(ACTION_FAIL)) {
                InstrumentRegistryException ex = new InstrumentRegistryException("fail: " + reason + " in '" + extension.getProvider().getId() + "' defined in " + extension.getProvider().getBaseDir());
                extension.setState(new StateFailed(reason));
                extension.getProvider().setState(new StateFailed(reason));
                throw new IllegalArgumentException(ex);
            }
            if (action.equals(ACTION_IGNORE)) {
                Log.log(Level.INFO, "ignore: " + reason + " in '" + extension.getProvider().getId() + "' defined in " + extension.getProvider().getBaseDir());
                extension.setState(new StateExcluded(reason));
                return;
            }
            if (action.equals(ACTION_SKIP)) {
                Log.log(Level.INFO, "skip: " + reason + " in '" + extension.getProvider().getId() + "' defined in " + extension.getProvider().getBaseDir());
                extension.setState(new StateExcluded(reason));
                extension.getProvider().setState(new StateExcluded(reason));
                return;
            }
            InstrumentRegistryException ex = new InstrumentRegistryException("absent action '" + action + "' not recognized in '" + extension.getProvider().getId() + "' defined in " + extension.getProvider().getBaseDir());
            extension.setState(new StateFailed(reason));
            extension.getProvider().setState(new StateFailed(reason));
            throw new IllegalArgumentException(ex);
        }
        if (Log.isLoggable(Level.FINE)) {
            Log.log(Level.FINE, "register " + StringTools.safeString(extension));
        }
        extensionPoint.registerExtension(extension);
    }

    protected void startExtensions() {
        for (StandardExtension extension : this.extensions) {
            try {
                this.startExtension(extension);
            }
            catch (InstrumentRegistryException e) {
                throw new InstrumentException(String.valueOf(StringTools.safeString(extension)) + " error when registering", e);
            }
        }
    }

    protected boolean startLocal() throws InstrumentException {
        if (Log.isLoggable(Level.FINE)) {
            Log.fine("register extensions for " + StringTools.safeString(this));
        }
        this.startExtensions();
        if (Log.isLoggable(Level.FINE)) {
            Log.fine("loading ready for " + StringTools.safeString(this));
        }
        return true;
    }

    protected void stop() {
        if (this.state.isStopped()) {
            return;
        }
        this.state = new StateStopped("stopped");
        this.stopLocal();
    }

    protected void stopExtension(StandardExtension extension) throws InstrumentRegistryException {
        StandardExtensionPoint extensionPoint = this.getRegistry().lookupExtensionPoint(extension.getExtensionPointId());
        if (extensionPoint == null) {
            return;
        }
        extensionPoint.unregisterExtension(extension);
        if (Log.isLoggable(Level.FINE)) {
            Log.log(Level.FINE, "deregistered " + StringTools.safeString(extension));
        }
    }

    protected void stopExtensions() {
        ReverseListIterator<StandardExtension> it = new ReverseListIterator<StandardExtension>(this.extensions);
        while (it.hasNext()) {
            StandardExtension extension = (StandardExtension)it.next();
            try {
                this.stopExtension(extension);
            }
            catch (InstrumentRegistryException e) {
                throw new InstrumentException(String.valueOf(StringTools.safeString(extension)) + " error when unregistering", e);
            }
        }
    }

    protected void stopLocal() {
        if (Log.isLoggable(Level.FINE)) {
            Log.fine("unregister extensions for " + StringTools.safeString(this));
        }
        this.stopExtensions();
    }

    protected boolean stopRequested(Set<?> visited) {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IInstrument '");
        sb.append(this.getId());
        sb.append("' defined in '");
        sb.append(this.getBaseDir());
        sb.append("'");
        return sb.toString();
    }

    protected void unregisterExtension(StandardExtension extension) throws InstrumentRegistryException {
        if (this.extensions.remove(extension) && this.getState().isStarted()) {
            this.stopExtension(extension);
        }
    }

    public class Facade
    implements IInstrument {
        @Override
        public void addPrerequisite(IInstrument prerequisite, String absentAction) {
            StandardInstrument.this.addPrerequisite(prerequisite, absentAction);
        }

        @Override
        public IExtension createExtension(String extensionPointId, String id) {
            return StandardInstrument.this.createExtension(extensionPointId, id);
        }

        @Override
        public void flush() throws IOException {
            StandardInstrument.this.flush();
        }

        @Override
        public final Object getAttribute(Object key) {
            return StandardInstrument.this.getAttribute(key);
        }

        @Override
        public File getBaseDir() {
            return StandardInstrument.this.getBaseDir();
        }

        @Override
        public ClassLoader getClassLoader() {
            return StandardInstrument.this.getClassLoader();
        }

        @Override
        public IExtension[] getExtensions() {
            return StandardInstrument.this.getExtensionFacades();
        }

        @Override
        public String getId() {
            return StandardInstrument.this.getId();
        }

        @Override
        public IInstrumentRegistry getInstrumentRegistry() {
            return StandardInstrument.this.getInstrumentRegistry().getFacade();
        }

        @Override
        public MessageBundle getMessageBundle() {
            return StandardInstrument.this.getMessageBundle();
        }

        @Override
        public String getMetaInfo(String name) {
            return StandardInstrument.this.getMetaInfo(name);
        }

        protected StandardInstrument getOwner() {
            return StandardInstrument.this;
        }

        @Override
        public IInstrumentPrerequisite[] getPrerequisites() {
            return StandardInstrument.this.getPrerequisiteFacades();
        }

        @Override
        public File getProfileDir() {
            return StandardInstrument.this.getProfileDir();
        }

        @Override
        public State getState() {
            return StandardInstrument.this.getState();
        }

        @Override
        public File getTempDir() {
            return StandardInstrument.this.getTempDir();
        }

        @Override
        public File getWorkingDir() {
            return StandardInstrument.this.getWorkingDir();
        }

        @Override
        public void registerExtension(IExtension extension) throws InstrumentRegistryException {
            StandardInstrument.this.registerExtension(((StandardExtension.Facade)extension).getOwner());
        }

        @Override
        public final Object removeAttribute(Object key) {
            return StandardInstrument.this.removeAttribute(key);
        }

        @Override
        public void removePrerequisite(IInstrument prerequisite) {
            StandardInstrument.this.removePrerequisite(prerequisite);
        }

        @Override
        public final Object setAttribute(Object key, Object o) {
            return StandardInstrument.this.setAttribute(key, o);
        }

        public String toString() {
            return StandardInstrument.this.toString();
        }

        @Override
        public void unregisterExtension(IExtension extension) throws InstrumentRegistryException {
            StandardInstrument.this.unregisterExtension(((StandardExtension.Facade)extension).getOwner());
        }
    }
}

