/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.impl.StandardInstrument;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class StandardInstrumentClassLoader
extends URLClassLoader {
    private final StandardInstrument instrument;

    protected static ClassLoader create(StandardInstrument instrument, ClassLoader parent) {
        File base = new File(instrument.getBaseDir(), "INSTRUMENT-INF");
        URL[] urls = StandardInstrumentClassLoader.createURLs(base);
        if (urls.length == 0) {
            return parent;
        }
        return new StandardInstrumentClassLoader(urls, instrument, parent);
    }

    protected static URL[] createURLs(File metaDir) {
        if (metaDir == null) {
            return new URL[0];
        }
        ArrayList<URL> result = new ArrayList<URL>();
        File jarDir = new File(metaDir, "lib");
        File classesDir = new File(metaDir, "classes");
        String[] jarFiles = jarDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar") && new File(dir, name).canRead();
            }
        });
        try {
            if (classesDir.exists()) {
                result.add(new URL("file", "", String.valueOf(classesDir.getAbsolutePath()) + "/"));
            }
            if (jarFiles != null) {
                int i = 0;
                while (i < jarFiles.length) {
                    result.add(new URL("file", "", String.valueOf(jarDir.getAbsolutePath()) + "/" + jarFiles[i]));
                    ++i;
                }
            }
            return result.toArray(new URL[result.size()]);
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
    }

    protected StandardInstrumentClassLoader(URL[] urls, StandardInstrument instrument, ClassLoader parent) {
        super(urls, parent);
        this.instrument = instrument;
    }

    public StandardInstrument getInstrument() {
        return this.instrument;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.getParent() != null ? this.getParent().loadClass(name) : StandardInstrumentClassLoader.getSystemClassLoader().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

