/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.StateExcluded;
import de.intarsys.claptz.StateFailed;
import de.intarsys.claptz.StatePrepared;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.claptz.impl.PACKAGE;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardInstrumentRegistry
implements IStartStop,
INotificationSupport,
IAttributeSupport {
    public static final String XE_EXTENSIONPOINT = "extensionpoint";
    public static final String XP_EXTENSIONPOINTS = "de.intarsys.claptz.extensionpoints";
    private Map<String, StandardExtensionPoint> extensionPoints = new LinkedHashMap<String, StandardExtensionPoint>();
    private IExtensionPointHandler installer = new ExtensionPointHandlerAdapter(){

        @Override
        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (StandardInstrumentRegistry.XE_EXTENSIONPOINT.equals(element.getName())) {
                StandardExtensionPoint newEP = StandardInstrumentRegistry.this.createExtensionPoint(extension.getProvider(), element);
                try {
                    if (element.attributeValue("installer", null) != null) {
                        IExtensionPointHandler installer = ElementTools.createObject(element, "installer", IExtensionPointHandler.class, extension.getProvider());
                        newEP.setInstaller(installer);
                    }
                    StandardInstrumentRegistry.this.registerExtensionPoint(newEP);
                }
                catch (Exception e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.SEVERE, extension, element, msg, e);
                }
            } else {
                return super.basicInstallInsert(extension, element);
            }
            return null;
        }

        @Override
        protected void basicUninstall(IExtension extension, IElement element) {
            if (StandardInstrumentRegistry.XE_EXTENSIONPOINT.equals(element.getName())) {
                String id = element.attributeValue("id", null);
                StandardExtensionPoint newEP = StandardInstrumentRegistry.this.lookupExtensionPoint(id);
                if (newEP != null) {
                    try {
                        StandardInstrumentRegistry.this.unregisterExtensionPoint(newEP);
                    }
                    catch (InstrumentRegistryException e) {
                        String msg = String.valueOf(StringTools.safeString(extension)) + " error unregistering extension";
                        Log.log(Level.SEVERE, msg, e);
                    }
                }
            } else {
                super.basicUninstall(extension, element);
            }
        }
    };
    private EventDispatcher dispatcher = new EventDispatcher(this);
    private AttributeMap attributes = new AttributeMap();
    private StandardExtensionPoint root;
    private static final Logger Log = PACKAGE.Log;
    private static final MessageBundle Msg = PACKAGE.Messages;
    private ClassLoader classLoader;
    private Set<StandardInstrument> failedInstruments = new HashSet<StandardInstrument>();
    private final Map<String, StandardInstrument> instruments = new HashMap<String, StandardInstrument>();
    private final IInstrumentRegistry facade = new Facade();
    private boolean started = false;
    private Set<StandardInstrument> startedInstruments = new HashSet<StandardInstrument>();
    private List<StandardInstrument> startList;
    private StandardInstrument rootInstrument;
    private final List<IInstrumentStore> stores = new ArrayList<IInstrumentStore>();
    private final Set<String> defines = new HashSet<String>();
    public static final String ACTION_DEFAULT = null;
    public static final String ACTION_FAIL = "fail";
    public static final String ACTION_IGNORE = "ignore";
    public static final String ACTION_SKIP = "skip";

    public StandardInstrumentRegistry() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        try {
            this.rootInstrument = new StandardInstrument(this, null);
            this.root = new StandardExtensionPoint(this.rootInstrument.getFacade(), XP_EXTENSIONPOINTS);
            this.root.setInstaller(this.installer);
            this.registerExtensionPoint(this.root);
        }
        catch (InstrumentRegistryException e) {
            throw new IllegalStateException("can't register de.intarsys.claptz.extensionpoints", e);
        }
        InstrumentRegistry.set(this.getFacade());
    }

    public void addInstrumentStore(IInstrumentStore store) {
        this.stores.add(store);
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void buildStartList(List<StandardInstrument> startList, StandardInstrument instrument) {
        if (!instrument.getState().isNew()) {
            return;
        }
        if (!this.ppIsDefined(instrument.getIfdef())) {
            String reason = "ifdef " + instrument.getIfdef() + " not defined";
            Log.log(Level.INFO, String.valueOf(reason) + " exclude instrument '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
            instrument.setState(new StateExcluded(reason));
            return;
        }
        if (!this.ppIsNotDefined(instrument.getIfnotdef())) {
            String reason = "ifnotdef " + instrument.getIfnotdef() + " defined";
            Log.log(Level.INFO, String.valueOf(reason) + " exclude instrument '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
            instrument.setState(new StateExcluded(reason));
            return;
        }
        List<StandardInstrumentPrerequisite> prerequisites = instrument.getPrerequisites();
        for (StandardInstrumentPrerequisite pre : prerequisites) {
            this.buildStartListPrerequisite(startList, instrument, pre);
        }
        if (!instrument.getState().isFailed() && !instrument.getState().isExcluded()) {
            instrument.setState(new StatePrepared(""));
            startList.add(instrument);
        }
    }

    protected void buildStartListPrerequisite(List startList, StandardInstrument instrument, StandardInstrumentPrerequisite prerequisite) {
        if (!this.ppIsDefined(prerequisite.getIfdef())) {
            String reason = "ifdef " + prerequisite.getIfdef() + " not defined";
            Log.log(Level.INFO, String.valueOf(reason) + ", exclude prerequisite '" + prerequisite.getInstrumentId() + "' for '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
            prerequisite.setState(new StateExcluded(reason));
            return;
        }
        if (!this.ppIsNotDefined(prerequisite.getIfnotdef())) {
            String reason = "ifnotdef " + prerequisite.getIfnotdef() + " defined";
            Log.log(Level.INFO, String.valueOf(reason) + ", exclude prerequisite '" + prerequisite.getInstrumentId() + "' for '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
            prerequisite.setState(new StateExcluded(reason));
            return;
        }
        StandardInstrument preInstrument = prerequisite.getInstrument();
        if (preInstrument != null) {
            this.buildStartList(startList, preInstrument);
        }
        if (preInstrument == null || preInstrument.getState().isFailed() || preInstrument.getState().isExcluded()) {
            String action = prerequisite.getAbsentAction();
            String reason = "missing prerequisite '" + prerequisite.getInstrumentId() + "'";
            if (action == ACTION_DEFAULT || action.equals(ACTION_FAIL)) {
                InstrumentRegistryException ex = new InstrumentRegistryException("fail: " + reason + " in '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                prerequisite.setState(new StateFailed(reason));
                instrument.setState(new StateFailed(reason));
                throw new IllegalArgumentException(ex);
            }
            if (action.equals(ACTION_IGNORE)) {
                Log.log(Level.INFO, "ignore: " + reason + " in '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                prerequisite.setState(new StateExcluded(reason));
            } else if (action.equals(ACTION_SKIP)) {
                Log.log(Level.INFO, "skip: " + reason + " in '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                prerequisite.setState(new StateExcluded(reason));
                instrument.setState(new StateExcluded(reason));
            } else {
                InstrumentRegistryException ex = new InstrumentRegistryException("absent action '" + action + "' not recognized in '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                prerequisite.setState(new StateFailed(reason));
                instrument.setState(new StateFailed(reason));
                throw new IllegalArgumentException(ex);
            }
        }
    }

    protected StandardExtensionPoint createExtensionPoint(IInstrument provider, IElement childElement) {
        String id = childElement.attributeValue("id", null);
        return new StandardExtensionPoint(provider, id);
    }

    protected StandardExtensionPoint createExtensionPoint(String id) {
        return new StandardExtensionPoint(null, id);
    }

    public IInstrument createInstrument(String id, IInstrumentStore store) {
        StandardInstrument instrument = new StandardInstrument(this, store);
        instrument.setId(id);
        return instrument.getFacade();
    }

    public void flush() throws IOException {
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected IExtensionPoint[] getExtensionPointFacades() {
        Collection<StandardExtensionPoint> tempEps = this.getExtensionPoints();
        IExtensionPoint[] result = new IExtensionPoint[tempEps.size()];
        int i = 0;
        for (StandardExtensionPoint tempEp : tempEps) {
            result[i++] = tempEp.getFacade();
        }
        return result;
    }

    protected Collection<StandardExtensionPoint> getExtensionPoints() {
        return this.extensionPoints.values();
    }

    public IInstrumentRegistry getFacade() {
        return this.facade;
    }

    protected IInstrument[] getInstruments() {
        IInstrument[] result = new IInstrument[this.instruments.size()];
        int i = 0;
        for (StandardInstrument current : this.instruments.values()) {
            result[i] = current.getFacade();
            ++i;
        }
        return result;
    }

    public List<IInstrumentStore> getStores() {
        return this.stores;
    }

    protected boolean isFailed(StandardInstrument instrument) {
        return this.failedInstruments.contains(instrument);
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected boolean isStarted(StandardInstrument instrument) {
        return this.startedInstruments.contains(instrument);
    }

    public void load(IInstrumentStore store) throws InstrumentRegistryException {
        store.load(this);
    }

    public StandardExtensionPoint lookupExtensionPoint(String name) {
        return this.extensionPoints.get(name);
    }

    public StandardInstrument lookupInstrument(String name) {
        return this.instruments.get(name);
    }

    public void ppDefine(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return;
        }
        String[] stringArray = symbols = symbolList.split(";");
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            String trimmed = symbol.trim();
            if (trimmed.length() > 0) {
                this.defines.add(trimmed);
            }
            ++n2;
        }
    }

    public Set<String> ppGetDefines() {
        return new HashSet<String>(this.defines);
    }

    public boolean ppIsDefined(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return true;
        }
        String[] stringArray = symbols = symbolList.split(";");
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            String trimmed = symbol.trim();
            if (trimmed.length() > 0 && !this.defines.contains(trimmed)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean ppIsNotDefined(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return true;
        }
        String[] stringArray = symbols = symbolList.split(";");
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            String trimmed = symbol.trim();
            if (trimmed.length() > 0 && this.defines.contains(trimmed)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void ppUndefine(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return;
        }
        String[] stringArray = symbols = symbolList.split(";");
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            String trimmed = symbol.trim();
            this.defines.remove(trimmed);
            ++n2;
        }
    }

    protected void registerExtensionPoint(StandardExtensionPoint extensionPoint) throws InstrumentRegistryException {
        StandardExtensionPoint prev = this.extensionPoints.get(extensionPoint.getId());
        if (prev != null) {
            return;
        }
        if (Log.isLoggable(Level.FINE)) {
            Log.log(Level.FINE, "register " + StringTools.safeString(extensionPoint));
        }
        this.extensionPoints.put(extensionPoint.getId(), extensionPoint);
        if (extensionPoint.getInstaller() != null) {
            extensionPoint.getInstaller().setExtensionPoint(extensionPoint.getFacade());
            if (!extensionPoint.getInstaller().isDeferred()) {
                extensionPoint.getInstaller().install();
            }
        }
    }

    public void registerInstrument(StandardInstrument instrument) throws InstrumentRegistryException {
        String id = instrument.getId();
        if (this.instruments.get(id) != null) {
            throw new InstrumentRegistryException(Msg.getString("StandardInstrumentRegistry.ExAlreadyRegistered", instrument.getId()));
        }
        this.ppDefine(id);
        this.instruments.put(id, instrument);
        if (this.isStarted()) {
            instrument.start();
        }
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    @Override
    public void start() {
        this.started = true;
        this.startList = new ArrayList<StandardInstrument>(100);
        ArrayList<StandardInstrument> tempInstruments = new ArrayList<StandardInstrument>(this.instruments.values());
        for (StandardInstrument instrument : tempInstruments) {
            this.buildStartList(this.startList, instrument);
        }
        for (StandardInstrument instrument : this.startList) {
            this.start(instrument);
        }
        this.dispatcher.triggerEvent(new StartedEvent(this));
    }

    protected void start(StandardInstrument instrument) {
        if (this.isFailed(instrument) || this.isStarted(instrument)) {
            return;
        }
        try {
            instrument.start();
            this.startedInstruments.add(instrument);
        }
        catch (RuntimeException e) {
            this.failedInstruments.add(instrument);
            Reporter.get().reportError(Msg.getString("StandardInstrumentRegistry.TitleError"), e.getMessage(), e, 0);
        }
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        ReverseListIterator<StandardInstrument> it = new ReverseListIterator<StandardInstrument>(this.startList);
        while (it.hasNext()) {
            StandardInstrument instrument = (StandardInstrument)it.next();
            this.stop(instrument);
        }
        this.startList.clear();
        this.instruments.clear();
        this.started = false;
        this.dispatcher.triggerEvent(new StoppedEvent(this));
    }

    protected void stop(StandardInstrument instrument) {
        if (this.isFailed(instrument) || !this.isStarted(instrument)) {
            return;
        }
        try {
            instrument.stop();
            this.startedInstruments.remove(instrument);
        }
        catch (RuntimeException e) {
            Reporter.get().reportError(Msg.getString("StandardInstrumentRegistry.TitleError"), e.getMessage(), e, 0);
        }
    }

    @Override
    public boolean stopRequested(Set visited) {
        return true;
    }

    protected void unregisterExtensionPoint(StandardExtensionPoint extensionPoint) throws InstrumentRegistryException {
        if (extensionPoint.getInstaller() != null) {
            extensionPoint.getInstaller().uninstall();
        }
        this.extensionPoints.remove(extensionPoint.getId());
        if (Log.isLoggable(Level.FINE)) {
            Log.log(Level.FINE, "deregistered " + StringTools.safeString(extensionPoint));
        }
    }

    protected void unregisterInstrument(StandardInstrument instrument) {
        if (instrument != null) {
            this.ppUndefine(instrument.getId());
            this.instruments.remove(instrument.getId());
        }
    }

    public class Facade
    implements IInstrumentRegistry {
        @Override
        public void addNotificationListener(EventType type, INotificationListener listener) {
            StandardInstrumentRegistry.this.addNotificationListener(type, listener);
        }

        @Override
        public IInstrument createInstrument(String id, IInstrumentStore store) {
            return StandardInstrumentRegistry.this.createInstrument(id, store);
        }

        @Override
        public Object getAttribute(Object key) {
            return StandardInstrumentRegistry.this.getAttribute(key);
        }

        @Override
        public IExtensionPoint[] getExtensionPoints() {
            return StandardInstrumentRegistry.this.getExtensionPointFacades();
        }

        @Override
        public IInstrument[] getInstruments() {
            return StandardInstrumentRegistry.this.getInstruments();
        }

        protected StandardInstrumentRegistry getOwner() {
            return StandardInstrumentRegistry.this;
        }

        @Override
        public void load(IInstrumentStore store) throws InstrumentRegistryException {
            StandardInstrumentRegistry.this.load(store);
        }

        @Override
        public IExtensionPoint lookupExtensionPoint(String name) {
            StandardExtensionPoint temp = StandardInstrumentRegistry.this.lookupExtensionPoint(name);
            return temp == null ? null : temp.getFacade();
        }

        @Override
        public IInstrument lookupInstrument(String name) {
            StandardInstrument instrument = StandardInstrumentRegistry.this.lookupInstrument(name);
            return instrument == null ? null : instrument.getFacade();
        }

        @Override
        public void registerInstrument(IInstrument instrument) throws InstrumentRegistryException {
            StandardInstrumentRegistry.this.registerInstrument(((StandardInstrument.Facade)instrument).getOwner());
        }

        @Override
        public Object removeAttribute(Object key) {
            return StandardInstrumentRegistry.this.removeAttribute(key);
        }

        @Override
        public void removeNotificationListener(EventType type, INotificationListener listener) {
            StandardInstrumentRegistry.this.removeNotificationListener(type, listener);
        }

        @Override
        public Object setAttribute(Object key, Object value) {
            return StandardInstrumentRegistry.this.setAttribute(key, value);
        }

        @Override
        public void unregisterInstrument(IInstrument instrument) throws InstrumentRegistryException {
            StandardInstrumentRegistry.this.unregisterInstrument(((StandardInstrument.Facade)instrument).getOwner());
        }
    }
}

