/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.CommonInstrumentStore;
import de.intarsys.claptz.io.PACKAGE;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderInstrumentStore
extends CommonInstrumentStore {
    public static final String META_DEFINITION = "instrument.xml";
    public static final String META_DIRECTORY = "INSTRUMENT-INF";
    public static final String META_PATH = "INSTRUMENT-INF/instrument.xml";
    private final ClassLoader classLoader;
    private static final Logger Log = PACKAGE.Log;

    public ClassLoaderInstrumentStore(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void flush(StandardInstrument instrument) throws IOException {
        throw new IOException("can't write to classpath");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void load(StandardInstrumentRegistry registry) throws InstrumentRegistryException {
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources(META_PATH);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                this.load(registry, resource);
            }
        }
        catch (IOException e) {
            throw new InstrumentRegistryException(e.getMessage(), e);
        }
    }

    protected void load(StandardInstrumentRegistry registry, URL resource) throws InstrumentRegistryException {
        InputStream is = null;
        try {
            try {
                is = resource.openStream();
                StandardInstrument instrument = new StandardInstrument(registry, this);
                instrument.setBaseDir(FileEnvironment.get().getBaseDir());
                IDocument doc = ElementFactory.get().parse(is);
                if (doc instanceof IStringEvaluatorAccess) {
                    ScopedResolver resolver = ScopedResolver.create(instrument.getExpressionEvaluator(), ExpressionEvaluator.get());
                    ((IStringEvaluatorAccess)((Object)doc)).setStringEvaluator(resolver);
                }
                instrument.configure(doc.getRootElement());
                String id = instrument.getId();
                if (registry.lookupInstrument(id) == null) {
                    registry.registerInstrument(instrument);
                    Log.log(Level.FINE, "instrument '" + id + "' definition at '" + resource + "'");
                } else {
                    Log.log(Level.INFO, "instrument '" + id + "' redefinition at '" + resource + "'");
                }
            }
            catch (Exception e) {
                throw new InstrumentRegistryException("error loading instrument at '" + resource + "'");
            }
        }
        finally {
            StreamTools.close(is);
        }
    }
}

