/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.CommonInstrumentStore;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.claptz.io.InstrumentSerializer;
import de.intarsys.claptz.io.PACKAGE;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.file.Loader;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.sax.SAXTools;
import de.intarsys.tools.serialize.xml.XMLSerializationContext;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParser;

public class DirectoryInstrumentStore
extends CommonInstrumentStore {
    private final File file;
    public static final String META_DEFINITION = "instrument.xml";
    public static final String META_DIRECTORY = "INSTRUMENT-INF";
    private static final MessageBundle Msg = PACKAGE.Messages;
    private static SAXParser parser;

    public static IInstrumentStore getLocal() {
        return new DirectoryInstrumentStore(new File(FileEnvironment.get().getProfileDir(), "instruments"));
    }

    protected static SAXParser getParser() {
        return parser;
    }

    public DirectoryInstrumentStore(File file) {
        assert (file != null);
        this.file = file;
        try {
            parser = SAXTools.getParserFactory().newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating SAXParser", e);
        }
    }

    @Override
    public void flush(StandardInstrument instrument) throws IOException {
        File tempBaseDir = instrument.getBaseDir();
        if (tempBaseDir == null) {
            tempBaseDir = new File(this.getFile(), instrument.getId());
        }
        this.save(instrument, tempBaseDir);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean isInstrumentHome(File home) {
        File metaDir = new File(home, META_DIRECTORY);
        File configFile = new File(metaDir, META_DEFINITION);
        return configFile.exists();
    }

    @Override
    public void load(StandardInstrumentRegistry registry) throws InstrumentRegistryException {
        this.loadAllInstruments(registry, this.file, Loader.ANY_FILTER);
    }

    protected void loadAllInstruments(StandardInstrumentRegistry registry, File base, IPathFilter filter) throws InstrumentRegistryException {
        if (this.isInstrumentHome(base)) {
            this.loadInstrument(registry, base);
        } else {
            if (!base.isDirectory()) {
                return;
            }
            String[] instrumentDirs = base.list();
            if (instrumentDirs == null || instrumentDirs.length == 0) {
                return;
            }
            int i = 0;
            while (i < instrumentDirs.length) {
                String path = instrumentDirs[i];
                if (filter.accept(path)) {
                    File file = new File(base, path);
                    this.loadInstrument(registry, file);
                }
                ++i;
            }
        }
    }

    public void loadInstrument(StandardInstrumentRegistry registry, File home) throws InstrumentRegistryException {
        File metaDir = new File(home, META_DIRECTORY);
        File configFile = new File(metaDir, META_DEFINITION);
        String name = home.getName();
        this.loadInstrument(registry, name, home, configFile);
    }

    /*
     * Exception decompiling
     */
    protected void loadInstrument(StandardInstrumentRegistry registry, String name, File base, File file) throws InstrumentRegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void save(StandardInstrument instrument, File dir) throws IOException {
        instrument.setBaseDir(dir);
        File tempInstrumentDir = new File(dir, META_DIRECTORY);
        File tempInstrumentFile = new File(tempInstrumentDir, META_DEFINITION);
        if (!tempInstrumentDir.exists()) {
            tempInstrumentDir.mkdirs();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(tempInstrumentFile);
            XMLSerializationContext context = new XMLSerializationContext(os, true);
            InstrumentSerializer serializer = new InstrumentSerializer(context);
            serializer.serialize(instrument);
        }
        catch (Throwable throwable) {
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(os);
    }
}

