/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.impl.StandardExtension;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializer;
import java.io.IOException;
import java.util.Iterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class InstrumentSerializer
extends XMLSerializer {
    public InstrumentSerializer(SerializationContext context) {
        super(context);
    }

    public InstrumentSerializer(SerializationContext context, boolean createDocument) {
        super(context, createDocument);
    }

    protected void serialize(IElement element, ContentHandler handler) throws SAXException {
        IStringEvaluator oldValue = null;
        try {
            if (element instanceof IStringEvaluatorAccess) {
                oldValue = ((IStringEvaluatorAccess)((Object)element)).getStringEvaluator();
                ((IStringEvaluatorAccess)((Object)element)).setStringEvaluator(null);
            }
            AttributesImpl attrs = new AttributesImpl();
            Iterator<Object> it = element.attributeNames();
            while (it.hasNext()) {
                String name = it.next();
                InstrumentSerializer.addAttribute(attrs, name, element.attributeTemplate(name));
            }
            this.doStartElement(handler, element.getName(), attrs);
            it = element.elementIterator();
            while (it.hasNext()) {
                IElement childElement = (IElement)it.next();
                this.serialize(childElement, handler);
            }
            this.doEndElement(handler, element.getName());
        }
        finally {
            if (element instanceof IStringEvaluatorAccess) {
                ((IStringEvaluatorAccess)((Object)element)).setStringEvaluator(oldValue);
            }
        }
    }

    @Override
    public void serialize(Object object, ContentHandler handler) throws SAXException, IOException {
        this.serialize((StandardInstrument)object, handler);
    }

    protected void serialize(StandardInstrument instrument, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        InstrumentSerializer.addAttribute(attrs, "id", instrument.getId());
        this.doStartElement(handler, "instrument", attrs);
        attrs = new AttributesImpl();
        this.doStartElement(handler, "requires", attrs);
        for (StandardInstrumentPrerequisite prerequisite : instrument.getPrerequisites()) {
            attrs = new AttributesImpl();
            InstrumentSerializer.addAttribute(attrs, "instrument", prerequisite.getInstrumentId());
            if (prerequisite.getAbsentAction() != null) {
                InstrumentSerializer.addAttribute(attrs, "absent", prerequisite.getAbsentAction());
            }
            this.doStartElement(handler, "prerequisite", attrs);
            this.doEndElement(handler, "prerequisite");
        }
        this.doEndElement(handler, "requires");
        for (StandardExtension extension : instrument.getExtensions()) {
            this.serialize(extension.getElement(), handler);
        }
        this.doEndElement(handler, "instrument");
    }
}

