/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.attachment;

import de.intarsys.tools.attachment.Attachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AttachmentTools {
    private static final Attachment[] EMPTY = new Attachment[0];
    private static final ThreadLocal<AttachmentList> threadAttachments = new ThreadLocal();

    public static void addAttachment(Attachment attachment) {
        if (attachment == null) {
            return;
        }
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.add(attachment);
    }

    public static void addAttachment(String key, Object value) {
        AttachmentTools.addAttachment(new Attachment(key, value));
    }

    public static void addAttachments(Attachment[] pAttachments) {
        if (pAttachments == null) {
            return;
        }
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.addAll(Arrays.asList(pAttachments));
    }

    public static void addAttachments(List<Attachment> pAttachments) {
        if (pAttachments == null) {
            return;
        }
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.addAll(pAttachments);
    }

    public static void attach() {
        AttachmentList temp = threadAttachments.get();
        if (temp == null) {
            temp = new AttachmentList();
            threadAttachments.set(temp);
        } else {
            ++temp.counter;
        }
    }

    protected static AttachmentList basicGetAttachments() {
        return threadAttachments.get();
    }

    public static void clearAttachments() {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.clear();
    }

    public static void detach() {
        AttachmentList temp = threadAttachments.get();
        if (temp == null) {
            return;
        }
        if (temp.counter <= 0) {
            temp.list.clear();
            threadAttachments.set(null);
        }
        --temp.counter;
    }

    public static Attachment getAttachment(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return null;
        }
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            return attachment;
        }
        return null;
    }

    public static Attachment[] getAttachments() {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return EMPTY;
        }
        return temp.list.toArray(new Attachment[temp.list.size()]);
    }

    public static Attachment[] getAttachments(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return EMPTY;
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    public static boolean hasAttachment(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean removeAttached(Object attached) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (attachment.getAttached() != attached) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static boolean removeAttachment(Attachment pAttachment) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (attachment != pAttachment) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static void removeAttachments(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (!key.equals(attachment.getKey())) continue;
            it.remove();
        }
    }

    static class AttachmentList {
        public List<Attachment> list = new ArrayList<Attachment>();
        public int counter = 0;

        AttachmentList() {
        }
    }
}

