/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.attribute;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.Map;
import java.util.WeakHashMap;

public class AttributeTools {
    private static final Map<Object, AttributeMap> objectAttributes = new WeakHashMap<Object, AttributeMap>();

    public static Object getAttribute(Object object, Object key) {
        if (object instanceof IAttributeSupport) {
            return ((IAttributeSupport)object).getAttribute(key);
        }
        return AttributeTools.getAttributeBasic(object, key);
    }

    public static synchronized Object getAttributeBasic(Object object, Object key) {
        AttributeMap attributes = objectAttributes.get(object);
        if (attributes == null) {
            return null;
        }
        return attributes.getAttribute(key);
    }

    public static Object removeAttribute(Object object, Object key) {
        if (object instanceof IAttributeSupport) {
            return ((IAttributeSupport)object).removeAttribute(key);
        }
        return AttributeTools.removeAttributeBasic(object, key);
    }

    public static synchronized Object removeAttributeBasic(Object object, Object key) {
        AttributeMap attributes = objectAttributes.get(object);
        if (attributes == null) {
            return null;
        }
        Object previous = attributes.removeAttribute(key);
        if (attributes.getKeys().length == 0) {
            objectAttributes.remove(object);
        }
        return previous;
    }

    public static Object setAttribute(Object object, Object key, Object value) {
        if (object instanceof IAttributeSupport) {
            return ((IAttributeSupport)object).setAttribute(key, value);
        }
        return AttributeTools.setAttributeBasic(object, key, value);
    }

    public static synchronized Object setAttributeBasic(Object object, Object key, Object value) {
        AttributeMap attributes = objectAttributes.get(object);
        if (attributes == null) {
            attributes = new AttributeMap();
            objectAttributes.put(object, attributes);
        }
        return attributes.setAttribute(key, value);
    }
}

