/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.authenticate.ICredential;
import de.intarsys.tools.authenticate.ICredentialScope;
import de.intarsys.tools.authenticate.ICredentialStore;
import java.util.HashMap;
import java.util.Map;

public class BasicCredentialProvider
implements ICredentialStore {
    private final Map<ICredentialScope, ICredential> credentials = new HashMap<ICredentialScope, ICredential>();

    @Override
    public boolean acceptCredentialScope(ICredentialScope scope) {
        return true;
    }

    @Override
    public void clear() {
        this.credentials.clear();
    }

    @Override
    public ICredential getCredential(ICredentialScope scope) {
        ICredential creds = this.credentials.get(scope);
        if (creds == null) {
            int bestMatchFactor = -1;
            ICredentialScope bestMatch = null;
            for (ICredentialScope current : this.credentials.keySet()) {
                int factor = scope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = this.credentials.get(bestMatch);
            }
        }
        return creds;
    }

    @Override
    public void removeCredential(ICredentialScope scope) {
        ICredential creds = this.credentials.remove(scope);
        if (creds == null) {
            int bestMatchFactor = -1;
            ICredentialScope bestMatch = null;
            for (ICredentialScope current : this.credentials.keySet()) {
                int factor = scope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = this.credentials.remove(bestMatch);
            }
        }
    }

    @Override
    public void setCredential(ICredentialScope scope, ICredential credential) {
        this.credentials.put(scope, credential);
    }
}

