/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.authenticate.CredentialProvider;
import de.intarsys.tools.authenticate.ICredential;
import de.intarsys.tools.authenticate.ICredentialProvider;
import de.intarsys.tools.authenticate.ICredentialScope;
import de.intarsys.tools.authenticate.ICredentialStore;
import java.util.ArrayList;
import java.util.List;

public class CompositeCredentialProvider
implements ICredentialStore {
    private final List<ICredentialProvider> providers = new ArrayList<ICredentialProvider>();

    public CompositeCredentialProvider() {
        CredentialProvider.set(this);
    }

    @Override
    public boolean acceptCredentialScope(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            if (!provider.acceptCredentialScope(scope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).clear();
        }
    }

    @Override
    public ICredential getCredential(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            ICredential credential = provider.getCredential(scope);
            if (credential == null) continue;
            return credential;
        }
        return null;
    }

    public void registerCredentialProvider(ICredentialProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeCredential(ICredentialScope scope) {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).removeCredential(scope);
        }
    }

    @Override
    public void setCredential(ICredentialScope scope, ICredential credential) {
        for (ICredentialProvider provider : this.providers) {
            if (!(provider instanceof ICredentialStore)) continue;
            ((ICredentialStore)provider).setCredential(scope, credential);
        }
    }
}

