/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.authenticate.ICredential;
import de.intarsys.tools.authenticate.NTCredential;
import de.intarsys.tools.authenticate.UserPasswordCredential;
import de.intarsys.tools.factory.CommonFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.text.ParseException;

public class CredentialFactory
extends CommonFactory<ICredential> {
    @Override
    protected ICredential basicCreateInstance(IArgs args) throws ObjectCreationException {
        IElement configuration = this.getConfiguration(args);
        if (configuration == null) {
            String userName;
            String qualifiedUserName = (String)args.get("qualifiedUserName");
            String domain = null;
            if (qualifiedUserName != null) {
                try {
                    Object[] tokens = NTCredential.FormatQualifiedUserName.parse(qualifiedUserName);
                    domain = (String)tokens[0];
                    userName = (String)tokens[1];
                }
                catch (ParseException ex) {
                    userName = qualifiedUserName;
                }
            } else {
                userName = (String)args.get("user");
            }
            char[] password = (char[])args.get("password");
            if (domain == null) {
                return new UserPasswordCredential(userName, password);
            }
            return new NTCredential(userName, password, domain);
        }
        String userName = configuration.attributeValue("user", null);
        String passwordEncrypted = configuration.attributeValue("password", null);
        String domain = configuration.attributeValue("domain", null);
        if (domain == null) {
            return new UserPasswordCredential(userName, passwordEncrypted, true);
        }
        return new NTCredential(userName, passwordEncrypted, domain, true);
    }

    @Override
    public Class<ICredential> getResultType() {
        return ICredential.class;
    }
}

