/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.authenticate.BasicCredentialProvider;
import de.intarsys.tools.authenticate.ICredential;
import de.intarsys.tools.authenticate.ICredentialScope;
import de.intarsys.tools.authenticate.ICredentialStore;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FilteredCredentialStore
implements ICredentialStore,
IElementConfigurable {
    private static final String TAG_PREDICATE = "predicate";
    private Predicate predicate;
    private ICredentialStore store = new BasicCredentialProvider();

    public FilteredCredentialStore() {
        this(new TruePredicate());
    }

    public FilteredCredentialStore(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean acceptCredentialScope(ICredentialScope scope) {
        return this.store.acceptCredentialScope(scope);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        IElement predicateElement = element.element(TAG_PREDICATE);
        if (predicateElement != null) {
            try {
                this.predicate = ElementTools.createObject(predicateElement, Predicate.class, null);
            }
            catch (ObjectCreationException ex) {
                throw new ConfigurationException(ex);
            }
        }
    }

    @Override
    public ICredential getCredential(ICredentialScope scope) {
        if (this.predicate.evaluate(scope)) {
            return this.store.getCredential(scope);
        }
        return null;
    }

    @Override
    public void removeCredential(ICredentialScope scope) {
        if (this.predicate.evaluate(scope)) {
            this.store.removeCredential(scope);
        }
    }

    @Override
    public void setCredential(ICredentialScope scope, ICredential credential) {
        if (this.predicate.evaluate(scope)) {
            this.store.setCredential(scope, credential);
        }
    }

    public static interface Predicate {
        public boolean evaluate(ICredentialScope var1);
    }

    private static class TruePredicate
    implements Predicate {
        private TruePredicate() {
        }

        @Override
        public boolean evaluate(ICredentialScope scope) {
            return true;
        }
    }
}

