/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordTools {
    private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDREFGHIJKLMNOPQRSTUVWXYZ!$%&/=?*+#-_";

    public static char[] createPassword(int length) {
        Random rand = new Random(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= length) {
            int pos = rand.nextInt(CHARS.length());
            sb.append(CHARS.charAt(pos));
            ++i;
        }
        return sb.toString().toCharArray();
    }

    public static String createSalt(int length) {
        byte[] saltBytes = ByteArrayTools.createRandomBytes(length);
        return new String(Base64.encode(saltBytes));
    }

    public static String hash(String salt, char[] password) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("missing SHA-1 hash");
        }
        if (!StringTools.isEmpty(salt)) {
            md.update(Base64.decode(salt));
        }
        try {
            md.update(new String(password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("missing UTF-8 encoding");
        }
        byte[] raw = md.digest();
        return new String(Base64.encode(raw));
    }
}

