/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.authenticate.CredentialFactory;
import de.intarsys.tools.authenticate.ICredential;
import de.intarsys.tools.crypto.CryptoEnvironment;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import java.io.IOException;

public class UserPasswordCredential
implements ICredential,
IElementSerializable {
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_QUALIFIED_USER_NAME = "qualifiedUserName";
    public static final String ATTR_USER = "user";
    private String password;
    private boolean passwordEncrypted;
    private String user;

    public UserPasswordCredential(String userName, char[] password) {
        this.user = userName;
        this.password = new String(password);
        this.passwordEncrypted = false;
        CryptoEnvironment cryptoEnvironment = CryptoEnvironment.get();
        if (cryptoEnvironment.getDefaultCryptdecFactoryEncrypt() != null) {
            try {
                this.password = cryptoEnvironment.encryptStringEncoded(this.password);
                this.passwordEncrypted = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public UserPasswordCredential(String userName, String password, boolean passwordEncrypted) {
        this.user = userName;
        this.password = password;
        this.passwordEncrypted = passwordEncrypted;
    }

    public char[] getPassword() {
        String passwordPlain = null;
        if (this.passwordEncrypted) {
            try {
                passwordPlain = CryptoEnvironment.get().decryptStringEncoded(this.password);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            passwordPlain = this.password;
        }
        return passwordPlain.toCharArray();
    }

    public String getQualifiedUserName() {
        return this.getUser();
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        if (!this.passwordEncrypted) {
            throw new ElementSerializationException();
        }
        element.setAttributeValue("factory", CredentialFactory.class.getName());
        element.setAttributeValue(ATTR_USER, this.user);
        element.setAttributeValue(ATTR_PASSWORD, this.password);
    }
}

