/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.bean;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.bean.IBeanProxy;
import de.intarsys.tools.bean.LazyBean;
import de.intarsys.tools.bean.PACKAGE;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = PACKAGE.Log;
    public static final String XP_BEANS = "de.intarsys.claptz.beans";
    public static final String XE_OBJECT = "object";
    public static final String XE_CLASS = "class";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_OBJECT.equals(element.getName())) {
            String onError = element.attributeValue("onerror", null);
            try {
                ClassLoader classLoader = extension.getProvider().getClassLoader();
                String id = element.attributeValue("bean-id", null);
                String create = element.attributeValue("bean-create", null);
                Object bean = "lazy".equals(create) ? new LazyBean(element, extension.getProvider()) : ElementTools.createObject(element, Object.class, extension.getProvider());
                BeanContainer.get().registerBean(id, bean);
                String registryId = element.attributeValue("bean-registry", null);
                if (StringTools.isEmpty(registryId)) return bean;
                Object registry = BeanContainer.get().lookupBean(registryId, Object.class);
                if (registry == null) {
                    throw new ObjectCreationException("registry '" + registryId + "' not found");
                }
                if (bean instanceof IBeanProxy) {
                    bean = ((IBeanProxy)bean).getObject();
                }
                ObjectTools.register(registry, bean);
                return bean;
            }
            catch (Exception e) {
                if ("ignore".equals(onError)) return null;
                if ("fail".equals(onError)) {
                    throw new RuntimeException(e);
                }
                String msg = "error creating object";
                this.log(Log, Level.WARNING, extension, element, msg, e);
                return null;
            }
        }
        if (!XE_CLASS.equals(element.getName())) return super.basicInstallInsert(extension, element);
        String onError = element.attributeValue("onerror", null);
        try {
            return ElementTools.createClass(element, "name", Class.class, extension.getProvider());
        }
        catch (Exception e) {
            if ("ignore".equals(onError)) return null;
            if ("fail".equals(onError)) {
                throw new RuntimeException(e);
            }
            String msg = "error creating object";
            this.log(Log, Level.WARNING, extension, element, msg, e);
            return null;
        }
    }
}

