/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.bean;

import de.intarsys.tools.bean.IBeanContainer;
import de.intarsys.tools.bean.IBeanProxy;
import de.intarsys.tools.bean.PACKAGE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StandardBeanContainer
implements IBeanContainer {
    private final Map<String, Object> beanMap = new HashMap<String, Object>();
    private final List<Object> beanList = new ArrayList<Object>();
    private static final Logger Log = PACKAGE.Log;

    @Override
    public synchronized <T> T lookupBean(String id, Class<T> expectedClass) {
        Object bean = this.beanMap.get(id);
        if (bean instanceof IBeanProxy) {
            IBeanProxy lazy = (IBeanProxy)bean;
            return (T)lazy.getObject();
        }
        return (T)bean;
    }

    @Override
    public synchronized <T> List<T> lookupBeans(Class<T> expectedClass) {
        ArrayList<Object> beans = new ArrayList<Object>(5);
        for (Object bean : this.beanList) {
            if (bean instanceof IBeanProxy) {
                IBeanProxy lazy = (IBeanProxy)bean;
                Object object = lazy.getObject();
                if (!expectedClass.isInstance(object)) continue;
                beans.add(object);
                continue;
            }
            if (!expectedClass.isInstance(bean)) continue;
            beans.add(bean);
        }
        return beans;
    }

    @Override
    public synchronized void registerBean(String id, Object object) {
        this.beanList.add(object);
        if (id != null) {
            this.beanMap.put(id, object);
        }
    }

    @Override
    public synchronized void unregisterBean(String id) {
        Object bean = this.beanMap.remove(id);
        this.beanList.remove(bean);
    }
}

