/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.category;

import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.Message;
import de.intarsys.tools.presentation.IPresentationSupport;

public class GenericCategory
implements ICategory,
IPresentationSupport,
IElementConfigurable {
    private Object description = null;
    private IElement element;
    private String iconName = null;
    private String id = null;
    private Object label = null;
    private String parentId;
    private Object tip = null;

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.element = pElement;
        this.id = this.element.attributeValue("id", null);
        if (this.id == null) {
            throw new ConfigurationException("category needs an id");
        }
        this.parentId = this.element.attributeValue("parent", null);
        IAttribute attribute = this.element.attribute("label");
        if (attribute != null) {
            this.setLabel(attribute.getData());
        }
        if ((attribute = this.element.attribute("tip")) != null) {
            this.setTip(attribute.getData());
        }
        if ((attribute = this.element.attribute("description")) != null) {
            this.setDescription(attribute.getData());
        }
        this.setIconName(this.element.attributeValue("icon", null));
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.getTip();
        }
        if (this.description instanceof Message) {
            this.description = ((Message)this.description).get();
        }
        return (String)this.description;
    }

    public IElement getElement() {
        return this.element;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.getId();
        }
        if (this.label instanceof Message) {
            this.label = ((Message)this.label).get();
        }
        return (String)this.label;
    }

    @Override
    public ICategory getParent() {
        return CategoryRegistry.get().lookupCategory(this.getParentId());
    }

    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getTip() {
        if (this.tip == null) {
            return this.getLabel();
        }
        if (this.tip instanceof Message) {
            this.tip = ((Message)this.tip).get();
        }
        return (String)this.tip;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public void setElement(IElement element) {
        this.element = element;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setTip(Object tip) {
        this.tip = tip;
    }
}

