/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.category;

import de.intarsys.tools.category.GenericCategory;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategoryRegistry;
import de.intarsys.tools.category.PACKAGE;
import de.intarsys.tools.message.MessageBundle;
import java.util.HashMap;
import java.util.Map;

public class StandardCategoryRegistry
implements ICategoryRegistry {
    private static final MessageBundle Msg = PACKAGE.Messages;
    public static final GenericCategory OTHER;
    public static final GenericCategory UNKNOWN;
    private Map categories = new HashMap();

    static {
        UNKNOWN = new GenericCategory();
        UNKNOWN.setId("de.intarsys.category.unknown");
        UNKNOWN.setLabel(Msg.getString("StandardCategoryRegistry.categoryUnknown.label"));
        OTHER = new GenericCategory();
        OTHER.setId("de.intarsys.category.other");
        OTHER.setLabel(Msg.getString("StandardCategoryRegistry.categoryOther.label"));
    }

    public StandardCategoryRegistry() {
        this.registerCategory(UNKNOWN);
        this.registerCategory(OTHER);
    }

    @Override
    public ICategory[] getCategories() {
        return this.categories.values().toArray(new ICategory[this.categories.size()]);
    }

    @Override
    public ICategory lookupCategory(String id) {
        ICategory result = (ICategory)this.categories.get(id);
        if (result == null) {
            result = UNKNOWN;
        }
        return result;
    }

    @Override
    public void registerCategory(ICategory category) {
        this.categories.put(category.getId(), category);
    }

    public int size() {
        return this.categories.size();
    }
}

