/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.codeexit;

import de.intarsys.tools.codeexit.CodeExitHandlerRegistry;
import de.intarsys.tools.codeexit.ICodeExitHandler;
import de.intarsys.tools.codeexit.ICodeExitMetaHandler;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorSupport;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public class CodeExit<T>
implements IFunctor<T>,
IClassLoaderAccess,
IElementConfigurable,
IElementSerializable,
IDeclarationSupport,
IPresentationSupport {
    public static final String EA_NAME = "name";
    public static final String EE_ARG = "arg";
    public static final String EE_HANDLER = "handler";
    public static final String EE_DECLARATIONS = "declarations";
    public static final String EA_SOURCE = "source";
    public static final String EA_TYPE = "type";
    private String source;
    private Object compiledSource;
    private IDeclarationBlock declarationBlock = new DeclarationBlock(this);
    private Object owner;
    private ClassLoader classLoader;
    private String type;
    private String name = "codeexit";
    private IElement element;
    private ICodeExitHandler handler;

    public static CodeExit<?> createFromElement(IElement element) throws ObjectCreationException {
        CodeExit codeExit = new CodeExit();
        try {
            codeExit.configure(element);
        }
        catch (ConfigurationException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
            if (cause instanceof ObjectCreationException) {
                throw (ObjectCreationException)cause;
            }
            throw new ObjectCreationException(e);
        }
        return codeExit;
    }

    public CodeExit() {
    }

    public CodeExit(Object owner) {
        this.setOwner(owner);
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        IElement sourceElement;
        this.element = pElement;
        String tempType = pElement.attributeValue(EA_TYPE, null);
        this.setType(tempType);
        String tempSource = pElement.attributeValue(EA_SOURCE, null);
        if (tempSource == null && (sourceElement = pElement.element(EA_SOURCE)) != null) {
            tempSource = sourceElement.getText();
        }
        this.setSource(tempSource);
        try {
            this.declarationBlock = new DeclarationBlock(this);
            new DeclarationIO().deserializeDeclarationBlock(this.declarationBlock, this.element);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    public CodeExit<?> copy() {
        CodeExit<T> clone = new CodeExit<T>();
        clone.classLoader = this.classLoader;
        clone.declarationBlock = (DeclarationBlock)this.declarationBlock.copy();
        clone.name = this.name;
        clone.owner = this.owner;
        clone.source = this.source;
        clone.type = this.type;
        return clone;
    }

    protected IFunctorCall createCall(IFunctorCall call) throws FunctorInvocationException {
        try {
            new ArgumentDeclarator().apply(this.getDeclarationBlock(), call.getArgs());
            return call;
        }
        catch (DeclarationException e) {
            throw new FunctorInvocationException(e);
        }
    }

    protected MapResolver createExpressionEvaluator(IArgs args) {
        MapResolver resolver = new MapResolver(true);
        resolver.put("args", new StaticArgsResolver(args));
        return resolver;
    }

    public boolean exists() {
        ICodeExitHandler handler = this.getCodeExitHandler();
        if (handler instanceof ICodeExitMetaHandler) {
            return ((ICodeExitMetaHandler)((Object)handler)).exists(this);
        }
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader result = this.classLoader;
        if (result == null) {
            result = this.getOwner() == null ? this.getClass().getClassLoader() : (this.getOwner() instanceof IClassLoaderSupport ? ((IClassLoaderSupport)this.getOwner()).getClassLoader() : this.getOwner().getClass().getClassLoader());
        }
        return result;
    }

    public ICodeExitHandler getCodeExitHandler() {
        return CodeExitHandlerRegistry.get().lookupCodeExitHandler(this.getType());
    }

    public Object getCompiledSource() {
        return this.compiledSource;
    }

    @Override
    public IDeclarationBlock getDeclarationBlock() {
        return this.declarationBlock;
    }

    @Override
    public String getDescription() {
        return this.getTip();
    }

    public IElement getElement() {
        return this.element;
    }

    public IElement getHandlerElement() {
        return this.element.element(EE_HANDLER);
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceExpanded(IArgs args) {
        IStringEvaluator evaluator = TemplateEvaluator.get();
        if (this.owner instanceof IStringEvaluatorSupport) {
            IStringEvaluator resolver = ((IStringEvaluatorSupport)this.owner).getStringEvaluator();
            evaluator = TaggedStringEvaluator.decorate(this.createExpressionEvaluator(args), resolver, ExpressionEvaluator.get());
        } else {
            evaluator = TaggedStringEvaluator.decorate(this.createExpressionEvaluator(args), ExpressionEvaluator.get());
        }
        try {
            return StringTools.safeString(evaluator.evaluate(this.source, Args.create()));
        }
        catch (EvaluationException e) {
            return this.source;
        }
    }

    @Override
    public String getTip() {
        return this.getLabel();
    }

    public String getType() {
        return this.type;
    }

    public boolean isDefinedSource() {
        return !StringTools.isEmpty(this.source);
    }

    public boolean isDefinedType() {
        return !StringTools.isEmpty(this.type);
    }

    @Override
    public T perform(IFunctorCall call) throws FunctorInvocationException {
        try {
            IFunctorCall forwardCall = this.createCall(call);
            if (this.handler == null) {
                this.handler = this.getCodeExitHandler();
                if (this.handler == null) {
                    throw new FunctorInvocationException("no ICodeExitHandler for type '" + this.getType() + "'");
                }
            }
            return (T)this.handler.perform(this, forwardCall);
        }
        catch (FunctorInvocationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new FunctorInvocationException("unexpected error", t);
        }
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        IElement child = element.newElement("perform");
        child.setAttributeValue(EA_TYPE, this.getType());
        child.setAttributeValue(EA_SOURCE, this.getSource());
        new DeclarationIO().serializeDeclarationBlock(this.getDeclarationBlock(), child);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.compiledSource = null;
    }

    public void setCompiledSource(Object compiledSource) {
        this.compiledSource = compiledSource;
    }

    public void setName(String name) {
        this.name = name;
        this.compiledSource = null;
    }

    public void setOwner(Object owner) {
        if (this.owner != null && this.owner != owner) {
            throw new IllegalStateException("can not reassign owner");
        }
        this.owner = owner;
        this.compiledSource = null;
    }

    public void setSource(String value) {
        this.source = value;
        this.compiledSource = null;
    }

    public void setType(String type) {
        this.type = type;
        this.compiledSource = null;
    }
}

