/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.codeexit;

import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.codeexit.CommonCodeExitHandler;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;

public class FunctorCodeExitHandler
extends CommonCodeExitHandler {
    protected IFunctor createFunctor(CodeExit codeExit) throws FunctorInvocationException {
        IElement handlerElement;
        this.checkCodeExitSource(codeExit);
        IFunctor functor = null;
        try {
            Class<?> clazz = Class.forName(codeExit.getSource(), true, codeExit.getClassLoader());
            functor = (IFunctor)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FunctorInvocationException(e);
        }
        catch (InstantiationException e) {
            throw new FunctorInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new FunctorInvocationException(e);
        }
        if (functor instanceof IElementConfigurable && (handlerElement = codeExit.getHandlerElement()) != null) {
            try {
                ((IElementConfigurable)((Object)functor)).configure(handlerElement);
            }
            catch (ConfigurationException e) {
                throw new FunctorInvocationException(e);
            }
        }
        return functor;
    }

    @Override
    public Object perform(CodeExit codeExit, IFunctorCall call) throws FunctorInvocationException {
        IFunctor functor = (IFunctor)codeExit.getCompiledSource();
        if (functor == null) {
            functor = this.createFunctor(codeExit);
            codeExit.setCompiledSource(functor);
        }
        try {
            return functor.perform(call);
        }
        catch (FunctorInvocationException e) {
            throw e;
        }
        catch (Error e) {
            throw new FunctorInvocationException(e);
        }
    }
}

