/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IBaseFunctor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayTools {
    public static <A, B> B[] collect(A[] array, IBaseFunctor<B> converter, Class<B> clazz) {
        ArrayList<B> result = new ArrayList<B>(array.length);
        A[] AArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            A a = AArray[n2];
            try {
                result.add(converter.perform(a));
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
            ++n2;
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static <A> A[] createFromList(Class<A> objectClass, List<A> list) {
        Object[] array = (Object[])Array.newInstance(objectClass, list.size());
        int index = 0;
        for (A element : list) {
            Array.set(array, index, element);
            ++index;
        }
        return array;
    }

    public static <A> A detect(A[] list, IBaseFunctor<Boolean> selector) {
        A[] AArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            A a = AArray[n2];
            try {
                if (selector.perform(a).booleanValue()) {
                    return a;
                }
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
            ++n2;
        }
        return null;
    }

    public static <T> T first(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return null;
        }
        return array[0];
    }

    public static <T> T last(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return null;
        }
        return array[array.length - 1];
    }

    public static <A> A[] reject(A[] array, IBaseFunctor<Boolean> selector, Class<A> clazz) {
        ArrayList<A> result = new ArrayList<A>();
        A[] AArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            A a = AArray[n2];
            try {
                if (!selector.perform(a).booleanValue()) {
                    result.add(a);
                }
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
            ++n2;
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static void reverse(byte[] array) {
        ArrayTools.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array, int index, int length) {
        int i = 0;
        while (i < length / 2) {
            byte temp = array[index + i];
            array[index + i] = array[index + length - i - 1];
            array[index + length - i - 1] = temp;
            ++i;
        }
    }

    public static <T> void reverse(T[] array) {
        ArrayTools.reverse(array, 0, array.length);
    }

    public static <T> void reverse(T[] array, int index, int length) {
        int i = 0;
        while (i < length / 2) {
            T temp = array[index + i];
            array[index + i] = array[index + length - i - 1];
            array[index + length - i - 1] = temp;
            ++i;
        }
    }

    public static <A> A[] select(A[] array, IBaseFunctor<Boolean> selector, Class<A> clazz) {
        ArrayList<A> result = new ArrayList<A>();
        A[] AArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            A a = AArray[n2];
            try {
                if (selector.perform(a).booleanValue()) {
                    result.add(a);
                }
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
            ++n2;
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static <T> T[] toArray(Class<T> clazz, Collection collection) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(array);
    }

    private ArrayTools() {
    }
}

