/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;

public class ByteArrayTools {
    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            length += array.length;
            ++n2;
        }
        byte[] concat = new byte[length];
        int index = 0;
        byte[][] byArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            System.arraycopy(array, 0, concat, index, array.length);
            index += array.length;
            ++n4;
        }
        return concat;
    }

    public static byte[] copy(byte[] bytes) {
        byte[] newbuf = new byte[bytes.length];
        System.arraycopy(bytes, 0, newbuf, 0, bytes.length);
        return newbuf;
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        byte[] newbuf = new byte[length];
        System.arraycopy(bytes, offset, newbuf, 0, length);
        return newbuf;
    }

    public static byte[] createBytes(int length, byte val) {
        byte[] bytes = new byte[length];
        Arrays.fill(bytes, val);
        return bytes;
    }

    public static byte[] createBytes(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return null;
            }
            value = Base64.decode((String)value);
        }
        if (value instanceof ILocator) {
            value = LocatorTools.getBytes((ILocator)value);
        }
        if (value instanceof ILocatorSupport) {
            value = LocatorTools.getBytes(((ILocatorSupport)value).getLocator());
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        try {
            return ConverterRegistry.get().convert(value, byte[].class);
        }
        catch (ConversionException e) {
            throw new IOException("can't convert " + value + " to byte[]");
        }
    }

    public static byte[] createRandomBytes(int length) {
        Random rand = new Random(System.currentTimeMillis());
        byte[] bytes = new byte[length];
        rand.nextBytes(bytes);
        return bytes;
    }

    public static boolean equals(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length - offset1 < length || array2.length - offset2 < length) {
            return false;
        }
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array1[offset1 + i] != array2[offset2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int indexOf(byte[] source, int sourceOffset, int sourceLen, byte[] pattern, int patternOffset, int patternLen, int fromIndex) {
        if (fromIndex >= sourceLen) {
            return patternLen == 0 ? sourceLen : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (patternLen == 0) {
            return fromIndex;
        }
        byte first = pattern[patternOffset];
        int max = sourceOffset + (sourceLen - patternLen);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + patternLen - 1;
                int k = patternOffset + 1;
                while (j < end && source[j] == pattern[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] bytes, byte[] pattern) {
        if (bytes == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int length = pattern.length;
        int i = 0;
        while (i < length) {
            if (bytes[i] != pattern[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void toBigEndianArray(byte[] bytes, int offset, int value, int size) {
        int bitShift = 0;
        int i = size - 1;
        while (i >= 0) {
            bytes[i + offset] = (byte)(value >>> bitShift & 0xFF);
            bitShift += 8;
            --i;
        }
    }

    public static byte[] toBigEndianArray(int value, int size) {
        byte[] result = new byte[size];
        int bitShift = 0;
        int i = size - 1;
        while (i >= 0) {
            result[i] = (byte)(value >>> bitShift & 0xFF);
            bitShift += 8;
            --i;
        }
        return result;
    }

    public static int toBigEndianInt(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        if (i < offset + size) {
            result = buffer[i++];
        }
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i++] & 0xFF;
        }
        return result;
    }

    public static int toBigEndianIntUnsigned(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
            ++i;
        }
        return result;
    }

    public static long toBigEndianLong(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        if (i < offset + size) {
            result = buffer[i++];
        }
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i++] & 0xFF;
        }
        return result;
    }

    public static long toBigEndianLongUnsigned(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset;
        while (i < offset + size) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
            ++i;
        }
        return result;
    }

    public static byte[] toByteArray(BigInteger r) {
        byte[] tmp = r.toByteArray();
        if (tmp[0] == 0) {
            byte[] ntmp = new byte[tmp.length - 1];
            System.arraycopy(tmp, 1, ntmp, 0, ntmp.length);
            return ntmp;
        }
        return tmp;
    }

    public static void toLittleEndianArray(byte[] bytes, int offset, int value, int size) {
        int i = 0;
        while (i < size) {
            int bitShift = 8 * i;
            bytes[i + offset] = (byte)(value >>> bitShift & 0xFF);
            ++i;
        }
    }

    public static void toLittleEndianArray(byte[] bytes, int offset, long value, int size) {
        int i = 0;
        while (i < size) {
            int bitShift = 8 * i;
            bytes[i + offset] = (byte)(value >>> bitShift & 0xFFL);
            ++i;
        }
    }

    public static byte[] toLittleEndianArray(int value, int size) {
        byte[] result = new byte[size];
        int i = 0;
        while (i < size) {
            int bitShift = 8 * i;
            result[i] = (byte)(value >>> bitShift & 0xFF);
            ++i;
        }
        return result;
    }

    public static byte[] toLittleEndianArray(long value, int size) {
        byte[] result = new byte[size];
        int i = 0;
        while (i < size) {
            int bitShift = 8 * i;
            result[i] = (byte)(value >>> bitShift & 0xFFL);
            ++i;
        }
        return result;
    }

    public static int toLittleEndianInt(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset + size - 1;
        if (i >= offset) {
            result = buffer[i--];
        }
        while (i >= offset) {
            result <<= 8;
            result |= buffer[i--] & 0xFF;
        }
        return result;
    }

    public static int toLittleEndianIntUnsigned(byte[] buffer, int offset, int size) {
        size = size < 4 ? size : 4;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        int result = 0;
        int i = offset + size - 1;
        while (i >= offset) {
            result <<= 8;
            result |= buffer[i] & 0xFF;
            --i;
        }
        return result;
    }

    public static long toLittleEndianLong(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        long result = 0L;
        int i = offset + size - 1;
        if (i >= offset) {
            result = buffer[i--];
        }
        while (i >= offset) {
            result <<= 8;
            result |= (long)(buffer[i--] & 0xFF);
        }
        return result;
    }

    public static long toLittleEndianLongUnsigned(byte[] buffer, int offset, int size) {
        size = size < 8 ? size : 8;
        size = size <= buffer.length - offset ? size : buffer.length - offset;
        long result = 0L;
        int i = offset + size - 1;
        while (i >= offset) {
            result <<= 8;
            result |= (long)(buffer[i] & 0xFF);
            --i;
        }
        return result;
    }
}

