/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IBaseFunctor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ListTools {
    public static <A, B> List<B> collect(Iterator<A> it, IBaseFunctor<B> converter) {
        ArrayList<B> result = new ArrayList<B>(5);
        while (it.hasNext()) {
            try {
                result.add(converter.perform(it.next()));
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <A, B> List<B> collect(List<A> list, IBaseFunctor<B> converter) {
        ArrayList<B> result = new ArrayList<B>(list.size());
        for (A a : list) {
            try {
                result.add(converter.perform(a));
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <A> A detect(List<A> list, IBaseFunctor<Boolean> selector) {
        for (A a : list) {
            try {
                if (!selector.perform(a).booleanValue()) continue;
                return a;
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static <T> T first(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <A> List<A> reject(List<A> list, IBaseFunctor<Boolean> selector) {
        ArrayList<A> result = new ArrayList<A>(list.size());
        for (A a : list) {
            try {
                if (selector.perform(a).booleanValue()) continue;
                result.add(a);
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <A> List<A> select(List<A> list, IBaseFunctor<Boolean> selector) {
        ArrayList<A> result = new ArrayList<A>(list.size());
        for (A a : list) {
            try {
                if (!selector.perform(a).booleanValue()) continue;
                result.add(a);
            }
            catch (FunctorInvocationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <T> List<T> toList(Enumeration<T> e) {
        ArrayList<T> result = new ArrayList<T>(5);
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>(5);
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> result = new ArrayList<T>(5);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> with(T ... object) {
        ArrayList<T> result = new ArrayList<T>(object.length);
        int i = 0;
        while (i < object.length) {
            result.add(object[i]);
            ++i;
        }
        return result;
    }

    private ListTools() {
    }
}

