/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapTools {
    public static final String SEPARATOR = "=";

    public static Map defineEntries(Map map, List<String> declarations) {
        if (declarations == null) {
            return map;
        }
        Iterator<String> i = declarations.iterator();
        while (i.hasNext()) {
            MapTools.defineEntries(map, i.next());
        }
        return map;
    }

    public static Map defineEntries(Map map, String definition) {
        if (StringTools.isEmpty(definition)) {
            return map;
        }
        StringReader r = new StringReader(definition);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    public static Object get(Map map, Object key, Object defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String get(Map map, Object key, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String toStringDeep(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        MapTools.toStringDeep(map, null, sb);
        return sb.toString();
    }

    public static void toStringDeep(Map<String, ?> map, String prefix, StringBuilder sb) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringTools.isEmpty(prefix)) {
                key = String.valueOf(prefix) + "." + key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                MapTools.toStringDeep((Map)value, key, sb);
                continue;
            }
            sb.append(key);
            sb.append(SEPARATOR);
            sb.append(StringTools.quote(String.valueOf(value)));
            sb.append(";");
        }
    }

    private MapTools() {
    }
}

