/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.component.PACKAGE;
import de.intarsys.tools.concurrent.ThreadTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpirationWatchdog {
    private ScheduledExecutorService cleanupExecutor;
    private final List<IExpirationSupport> resources = new ArrayList<IExpirationSupport>();
    private final Object lock = new Object();
    private final Object owner;
    private final Runnable command = new Runnable(){

        @Override
        public void run() {
            ExpirationWatchdog.this.cleanup();
        }
    };
    private long cleanupInterval = 60000L;
    private static final Logger Log = PACKAGE.Log;

    public ExpirationWatchdog(Object owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        ArrayList<IExpirationSupport> tempResources;
        Log.log(Level.FINER, "expiration watchdog cleanup");
        Object object = this.lock;
        synchronized (object) {
            tempResources = new ArrayList<IExpirationSupport>(this.resources);
        }
        for (IExpirationSupport resource : tempResources) {
            if (!resource.isExpired()) continue;
            Log.log(Level.FINER, "expiration watchdog dispose resource");
            this.unregisterResource(resource);
            ((IDisposable)((Object)resource)).dispose();
        }
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public Object getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResource(IExpirationSupport resource) {
        assert (resource instanceof IDisposable);
        Object object = this.lock;
        synchronized (object) {
            this.start();
            this.resources.add(resource);
        }
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    protected void start() {
        if (this.cleanupExecutor != null) {
            return;
        }
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon("session registry reaper"));
        this.cleanupExecutor.scheduleWithFixedDelay(this.command, this.getCleanupInterval(), this.getCleanupInterval(), TimeUnit.MILLISECONDS);
    }

    protected void stop() {
        if (this.cleanupExecutor == null) {
            return;
        }
        this.cleanupExecutor.shutdown();
        this.cleanupExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResource(IExpirationSupport resource) {
        Object object = this.lock;
        synchronized (object) {
            this.resources.remove(resource);
            if (this.resources.size() == 0) {
                this.stop();
            }
        }
    }
}

