/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.PACKAGE;
import de.intarsys.tools.reflect.ClassTools;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFutureTask<R>
implements Runnable,
Future<R> {
    protected static final Logger Log = PACKAGE.Log;
    private ITaskListener taskListener;
    private static int COUNTER = 0;
    private final Object lockTask = new Object();
    private Throwable exception;
    private R result;
    private boolean cancelled = false;
    private boolean computed = false;
    private final int id = COUNTER++;
    private boolean active = false;
    private boolean asynch = false;
    private final String label = String.valueOf(ClassTools.getUnqualifiedName(this.getClass())) + "-" + this.id;

    protected AbstractFutureTask() {
    }

    protected AbstractFutureTask(ITaskListener callback) {
        this.taskListener = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable basicGetException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R basicGetResult() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interrupt) {
        boolean tempActive;
        Object object = this.lockTask;
        synchronized (object) {
            block10: {
                block9: {
                    if (!this.cancelled) break block9;
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " can't cancel, already canceled");
                    }
                    return false;
                }
                if (!this.computed) break block10;
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " can't cancel, already computed");
                }
                return false;
            }
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " cancel " + (this.active ? "active" : "inactive") + " task");
            }
            tempActive = this.active;
            this.cancelled = true;
            this.lockTask.notifyAll();
        }
        if (!tempActive) {
            this.taskCancelled();
        }
        return true;
    }

    protected abstract R compute() throws Exception;

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remainNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long lastNanos = System.nanoTime();
        Object object = this.lockTask;
        synchronized (object) {
            while (true) {
                long tempMillis;
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (this.computed) {
                    if (this.exception == null) return this.result;
                    throw new ExecutionException(this.exception);
                }
                if (timeout < 0L) return null;
                if (timeout != 0L) {
                    long nowNanos = System.nanoTime();
                    remainNanos -= nowNanos - lastNanos;
                    lastNanos = nowNanos;
                }
                if ((tempMillis = TimeUnit.MILLISECONDS.convert(remainNanos, TimeUnit.NANOSECONDS)) <= 0L && timeout != 0L) {
                    throw new TimeoutException();
                }
                this.lockTask.wait(tempMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITaskListener getTaskListener() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.taskListener;
        }
    }

    protected final void handleException() {
        block8: {
            try {
                if (this.cancelled) {
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " exception undo");
                    }
                    this.undo();
                    this.taskCancelled();
                    break block8;
                }
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " exception");
                }
                try {
                    this.taskFailed();
                }
                finally {
                    this.handleFinally();
                }
            }
            catch (Exception e) {
                Log.log(Level.SEVERE, this + " exception in exception handling", e);
            }
        }
    }

    protected final void handleFinally() {
        try {
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " finally");
            }
            this.taskFinally();
        }
        catch (Exception e) {
            Log.log(Level.SEVERE, this + " exception in finally handling", e);
        }
    }

    protected final void handleResult() {
        block8: {
            try {
                if (this.cancelled) {
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " computed undo");
                    }
                    this.undo();
                    this.taskCancelled();
                    break block8;
                }
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " computed");
                }
                try {
                    this.taskFinished();
                }
                finally {
                    this.handleFinally();
                }
            }
            catch (Exception e) {
                Log.log(Level.SEVERE, this + " exception in result handling", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.active;
        }
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.computed || this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lockTask;
        synchronized (object) {
            this.active = false;
            this.computed = false;
            this.exception = null;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.active || this.cancelled || this.computed) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " will not run" + (this.cancelled ? " (canceled)" : ""));
                }
                return;
            }
            this.active = true;
        }
        try {
            this.taskStarted();
            R tempResult = this.compute();
            if (!this.isAsynch()) {
                this.setResult(tempResult);
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
    }

    public final void runAsync() {
        this.setAsynch(true);
        this.run();
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setException(Throwable e) {
        Object object = this.lockTask;
        synchronized (object) {
            this.computed = true;
            this.active = false;
            this.exception = e;
            this.lockTask.notifyAll();
        }
        this.handleException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(R object) {
        Object object2 = this.lockTask;
        synchronized (object2) {
            this.computed = true;
            this.active = false;
            this.result = object;
            this.lockTask.notifyAll();
        }
        this.handleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskListener(ITaskListener taskListener) {
        Object object = this.lockTask;
        synchronized (object) {
            this.taskListener = taskListener;
        }
    }

    protected void taskCancelled() {
        if (this.taskListener != null) {
            this.taskListener.taskCancelled(this);
        }
    }

    protected void taskFailed() {
        if (this.taskListener != null) {
            this.taskListener.taskFailed(this, new ExecutionException(this.basicGetException()));
        }
    }

    protected void taskFinally() {
    }

    protected void taskFinished() {
        if (this.taskListener != null) {
            this.taskListener.taskFinished(this, this.basicGetResult());
        }
    }

    protected void taskStarted() throws Exception {
        if (this.taskListener != null) {
            this.taskListener.taskStarted(this);
        }
    }

    public String toString() {
        return this.getLabel();
    }

    protected void undo() {
    }
}

