/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadTools {
    private static final Logger Log = Logger.getLogger("de.intarsys.tools.concurrent.ThreadTools");

    public static Thread newThread(Runnable r, String name) {
        return ThreadTools.newThread(r, name, 5);
    }

    public static Thread newThread(Runnable r, String name, int priority) {
        Thread thread = new Thread(r, name);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Log.log(Level.WARNING, "uncaught exception in " + t, e);
            }
        });
        thread.setPriority(priority);
        return thread;
    }

    public static Thread newThreadDaemon(Runnable r, String name) {
        return ThreadTools.newThreadDaemon(r, name, 5);
    }

    public static Thread newThreadDaemon(Runnable r, String name, int priority) {
        Thread thread = new Thread(r, name);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Log.log(Level.WARNING, "uncaught exception in " + t, e);
            }
        });
        thread.setPriority(priority);
        return thread;
    }

    public static ThreadFactory newThreadFactory(String name) {
        return ThreadTools.newThreadFactory(name, 5);
    }

    public static ThreadFactory newThreadFactory(final String name, final int priority) {
        return new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                String tempName = name;
                if (this.counter != 0) {
                    tempName = String.valueOf(name) + "-" + this.counter;
                }
                ++this.counter;
                return ThreadTools.newThread(r, tempName, priority);
            }
        };
    }

    public static ThreadFactory newThreadFactoryDaemon(String name) {
        return ThreadTools.newThreadFactoryDaemon(name, 5);
    }

    public static ThreadFactory newThreadFactoryDaemon(final String name, final int priority) {
        return new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                String tempName = name;
                if (this.counter != 0) {
                    tempName = String.valueOf(name) + "-" + this.counter;
                }
                ++this.counter;
                return ThreadTools.newThreadDaemon(r, tempName, priority);
            }
        };
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

