/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.Undefined;
import java.util.HashMap;
import java.util.Map;

public class DoubleDispatchConverter
implements IConverter<Object, Object> {
    private final Map<Class, IConverter> converters = new HashMap<Class, IConverter>();
    private final Class targetType;

    public DoubleDispatchConverter(Class targetType) {
        this.targetType = targetType;
    }

    @Override
    public Object convert(Object source) throws ConversionException {
        IConverter<?, ?> converter = this.lookupConverter(source);
        if (converter == null) {
            if (this.targetType == Canonical.class) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + this.getTargetType());
            }
            Canonical canonical = ConverterRegistry.get().convert(source, Canonical.class);
            if (canonical == source) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + this.getTargetType());
            }
            return ConverterRegistry.get().convert(canonical, this.getTargetType());
        }
        return converter.convert(source);
    }

    @Override
    public Class<?> getSourceType() {
        return Object.class;
    }

    @Override
    public Class<?> getTargetType() {
        return this.targetType;
    }

    private IConverter<?, ?> lookupConverter(Class<?> clazz) {
        IConverter<?, ?> result = this.converters.get(clazz);
        if (result != null) {
            return result;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            result = this.lookupConverter(interfaces[i]);
            if (result != null) {
                return result;
            }
            ++i;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (result = this.lookupConverter(superClass)) != null) {
            return result;
        }
        return null;
    }

    protected IConverter<?, ?> lookupConverter(Object source) {
        Class clazz = source == null ? Undefined.class : source.getClass();
        IConverter<?, ?> converter = this.lookupConverter(clazz);
        return converter;
    }

    public void registerConverter(IConverter converter) {
        this.converters.put(converter.getSourceType(), converter);
    }

    public void unregisterConverter(IConverter converter) {
        this.converters.remove(converter.getSourceType());
    }
}

