/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.DoubleDispatchConverter;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.IConverterRegistry;
import de.intarsys.tools.converter.PACKAGE;
import de.intarsys.tools.provider.Providers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardConverterRegistry
implements IConverterRegistry {
    private static final Logger Log = PACKAGE.Log;
    private final Map<Class, IConverter> converters = new HashMap<Class, IConverter>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    public Object convert(Object source, Class targetType) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (targetType == Object.class) {
            return source;
        }
        if (targetType.isInstance(source)) {
            return source;
        }
        IConverter converter = this.lookupConverter(targetType);
        if (converter == null) {
            Canonical canonical = ConverterRegistry.get().convert(source, Canonical.class);
            if (canonical == source) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + targetType);
            }
            try {
                return ConverterRegistry.get().convert(canonical, targetType);
            }
            catch (ConversionException e) {
                throw new ConversionException("can't convert " + source.getClass().getName() + " to " + targetType, e);
            }
        }
        return converter.convert(source);
    }

    protected Iterator<IConverter> findProviders() {
        return Providers.get().lookupProviders(IConverter.class);
    }

    protected void init() {
        if (!this.isLookupProviders() || this.initialized) {
            return;
        }
        this.initialized = true;
        Iterator<IConverter> ps = this.findProviders();
        while (ps.hasNext()) {
            try {
                this.registerConverter(ps.next());
            }
            catch (Throwable e) {
                Log.log(Level.WARNING, "error creating converter", e);
            }
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IConverter lookupConverter(Class targetType) {
        this.init();
        return this.converters.get(targetType);
    }

    @Override
    public synchronized void registerConverter(IConverter converter) {
        IConverter tempConverter = this.converters.get(converter.getTargetType());
        if (tempConverter == null) {
            tempConverter = new DoubleDispatchConverter(converter.getTargetType());
            ((DoubleDispatchConverter)tempConverter).registerConverter(converter);
            this.converters.put(tempConverter.getTargetType(), tempConverter);
        } else {
            ((DoubleDispatchConverter)tempConverter).registerConverter(converter);
        }
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterConverter(IConverter converter) {
        IConverter tempConverter = this.converters.get(converter.getTargetType());
        if (tempConverter != null) {
            ((DoubleDispatchConverter)tempConverter).unregisterConverter(converter);
        }
    }
}

