/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.ICryptdecFactory;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public class CryptoEnvironment {
    private static final CryptoEnvironment ACTIVE = new CryptoEnvironment();
    private Map<String, ICryptdecFactory> factories = new HashMap<String, ICryptdecFactory>();
    private ICryptdecFactory defaultCryptdecFactoryEncrypt;
    private ICryptdecFactory defaultCryptdecFactoryDecrypt;

    public static CryptoEnvironment get() {
        return ACTIVE;
    }

    private CryptoEnvironment() {
    }

    public ICryptdec createCryptdec(String id) throws IOException {
        try {
            ICryptdecFactory factory = this.factories.get(id);
            if (factory == null) {
                throw new IOException("unsupported cryptdec " + id);
            }
            return this.factories.get(id).createCryptdec();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected ICryptdec createDefaultCryptdecDecrypt() throws IOException {
        if (this.defaultCryptdecFactoryDecrypt == null) {
            throw new IOException("default cryptdec not defined");
        }
        try {
            return this.defaultCryptdecFactoryDecrypt.createCryptdec();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected ICryptdec createDefaultCryptdecEncrypt() throws IOException {
        if (this.defaultCryptdecFactoryEncrypt == null) {
            throw new IOException("default cryptdec not defined");
        }
        try {
            return this.defaultCryptdecFactoryEncrypt.createCryptdec();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public byte[] decryptBytes(byte[] bytes) throws IOException {
        return this.decryptBytes(bytes, null);
    }

    public byte[] decryptBytes(byte[] bytes, ICryptdec cryptdec) throws IOException {
        if (cryptdec == null) {
            cryptdec = this.createDefaultCryptdecDecrypt();
        }
        return cryptdec.decrypt(bytes);
    }

    public byte[] decryptBytesEncoded(String value) throws IOException {
        return this.decryptBytesEncoded(value, null);
    }

    public byte[] decryptBytesEncoded(String value, ICryptdec cryptdec) throws IOException {
        try {
            String tempValue;
            ICryptdec tempCryptdec;
            String[] parts = value.split("#");
            if (parts.length == 1) {
                tempCryptdec = cryptdec;
                tempValue = parts[0];
            } else {
                tempCryptdec = this.createCryptdec(parts[0]);
                tempValue = parts[1];
            }
            if (StringTools.isEmpty(tempValue)) {
                return new byte[0];
            }
            byte[] bytes = Base64.decode(StringTools.toByteArray(tempValue));
            byte[] decrypted = this.decryptBytes(bytes, tempCryptdec);
            return decrypted;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String decryptString(String value) throws IOException {
        return this.decryptString(value, null);
    }

    public String decryptString(String value, ICryptdec cryptdec) throws IOException {
        try {
            if (StringTools.isEmpty(value)) {
                return value;
            }
            byte[] bytes = Base64.decode(StringTools.toByteArray(value));
            byte[] decrypted = this.decryptBytes(bytes, cryptdec);
            return new String(decrypted, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String decryptStringEncoded(String value) throws IOException {
        return this.decryptStringEncoded(value, null);
    }

    public String decryptStringEncoded(String value, ICryptdec cryptdec) throws IOException {
        try {
            byte[] decrypted = this.decryptBytesEncoded(value, cryptdec);
            return new String(decrypted, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public byte[] encryptBytes(byte[] bytes) throws IOException {
        return this.encryptBytes(bytes, null);
    }

    public byte[] encryptBytes(byte[] bytes, ICryptdec cryptdec) throws IOException {
        if (cryptdec == null) {
            cryptdec = this.createDefaultCryptdecEncrypt();
        }
        return cryptdec.encrypt(bytes);
    }

    public String encryptBytesEncoded(byte[] value) throws IOException {
        if (this.defaultCryptdecFactoryEncrypt == null) {
            throw new IllegalStateException("default cryptdec not defined");
        }
        try {
            ICryptdec cryptdec = this.defaultCryptdecFactoryEncrypt.createCryptdec();
            return this.encryptBytesEncoded(value, cryptdec);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public String encryptBytesEncoded(byte[] bytes, ICryptdec cryptdec) throws IOException {
        try {
            if (cryptdec == null) {
                cryptdec = this.createDefaultCryptdecEncrypt();
            }
            byte[] encrypted = this.encryptBytes(bytes, cryptdec);
            return String.valueOf(cryptdec.getId()) + "#" + new String(Base64.encode(encrypted));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String encryptCharsEncoded(char[] value) throws IOException {
        return this.encryptCharsEncoded(value, null);
    }

    public String encryptCharsEncoded(char[] value, ICryptdec cryptdec) throws IOException {
        if (cryptdec == null) {
            cryptdec = this.createDefaultCryptdecEncrypt();
        }
        byte[] bytes = new String(value).getBytes("UTF8");
        return this.encryptBytesEncoded(bytes, cryptdec);
    }

    public String encryptString(String value) throws IOException {
        return this.encryptString(value, null);
    }

    public String encryptString(String value, ICryptdec cryptdec) throws IOException {
        try {
            if (cryptdec == null) {
                cryptdec = this.createDefaultCryptdecEncrypt();
            }
            byte[] bytes = value.getBytes("UTF8");
            byte[] encrypted = this.encryptBytes(bytes, cryptdec);
            return new String(Base64.encode(encrypted));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String encryptStringEncoded(String value) throws IOException {
        return this.encryptStringEncoded(value, null);
    }

    public String encryptStringEncoded(String value, ICryptdec cryptdec) throws IOException {
        try {
            if (cryptdec == null) {
                cryptdec = this.createDefaultCryptdecEncrypt();
            }
            byte[] bytes = value.getBytes("UTF8");
            byte[] encrypted = this.encryptBytes(bytes, cryptdec);
            return String.valueOf(cryptdec.getId()) + "#" + new String(Base64.encode(encrypted));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public ICryptdecFactory getDefaultCryptdecFactoryDecrypt() {
        return this.defaultCryptdecFactoryDecrypt;
    }

    public ICryptdecFactory getDefaultCryptdecFactoryEncrypt() {
        return this.defaultCryptdecFactoryEncrypt;
    }

    public void registerCryptdecFactory(ICryptdecFactory factory) {
        if (this.factories.containsKey(factory.getId())) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.factories.put(factory.getId(), factory);
    }

    public void setDefaultCryptdecFactoryDecrypt(ICryptdecFactory factory) {
        if (this.defaultCryptdecFactoryDecrypt != null) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.defaultCryptdecFactoryDecrypt = factory;
    }

    public void setDefaultCryptdecFactoryEncrypt(ICryptdecFactory factory) {
        if (this.defaultCryptdecFactoryEncrypt != null) {
            throw new IllegalStateException("can't redefine cryptdecs");
        }
        this.defaultCryptdecFactoryEncrypt = factory;
    }
}

