/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.authenticate.PasswordTools;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.PBAES128CryptdecFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SecretMemory {
    private final transient ICryptdec cryptdec;
    private final transient Map<Object, byte[]> memory = new HashMap<Object, byte[]>();

    private static ICryptdec createSessionCryptdec() {
        char[] passPhrase = null;
        byte[] salt = null;
        byte[] iv = null;
        passPhrase = PasswordTools.createPassword(16);
        salt = ByteArrayTools.createRandomBytes(8);
        iv = ByteArrayTools.createRandomBytes(16);
        try {
            ICryptdec iCryptdec = new PBAES128CryptdecFactory("session", iv, passPhrase, salt, 19).createCryptdec();
            return iCryptdec;
        }
        catch (Exception e) {
            throw new IllegalStateException("cryptec initialization error", e);
        }
        finally {
            Arrays.fill(passPhrase, ' ');
            Arrays.fill(salt, (byte)0);
            Arrays.fill(iv, (byte)0);
        }
    }

    public SecretMemory() {
        this(SecretMemory.createSessionCryptdec());
    }

    public SecretMemory(ICryptdec cryptdec) {
        this.cryptdec = cryptdec;
    }

    public void clear() {
        this.memory.clear();
    }

    public byte[] getBytes(Object key) throws IOException {
        byte[] crypted = this.memory.get(key);
        if (crypted == null) {
            return null;
        }
        byte[] decrypted = this.cryptdec.decrypt(crypted);
        return decrypted;
    }

    public char[] getCharacters(Object key) throws IOException {
        byte[] crypted = this.memory.get(key);
        if (crypted == null) {
            return null;
        }
        byte[] decrypted = this.cryptdec.decrypt(crypted);
        char[] secret = new char[decrypted.length / 2];
        int k = 0;
        int i = 0;
        while (i < secret.length) {
            char c;
            secret[i] = c = (char)(((decrypted[k++] & 0xFF) << 8) + (decrypted[k++] & 0xFF));
            ++i;
        }
        return secret;
    }

    public Object put(byte[] secret) throws IOException {
        byte[] crypted = this.cryptdec.encrypt(secret);
        Object key = new Object();
        this.memory.put(key, crypted);
        return key;
    }

    public Object put(char[] secret) throws IOException {
        byte[] bytes = new byte[secret.length * 2];
        int k = 0;
        int i = 0;
        while (i < secret.length) {
            char c = secret[i];
            bytes[k++] = (byte)(c >> 8);
            bytes[k++] = (byte)c;
            ++i;
        }
        byte[] crypted = this.cryptdec.encrypt(bytes);
        Object key = new Object();
        this.memory.put(key, crypted);
        return key;
    }

    public void remove(Object key) {
        this.memory.remove(key);
    }
}

