/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.hex.HexTools;
import java.io.IOException;
import java.util.Arrays;

public class Digest
implements IDigest {
    private final String algorithmName;
    private final byte[] digest;

    protected Digest(String name, byte[] digest) {
        this.algorithmName = name;
        this.digest = digest;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Digest)) {
            return false;
        }
        Digest otherDigest = (Digest)obj;
        return otherDigest.algorithmName.equals(this.algorithmName) && Arrays.equals(otherDigest.digest, this.digest);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public byte[] getBytes() {
        return this.digest;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return DigestTools.encode(this);
    }

    public int getSize() {
        return this.digest.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest);
    }

    public String toString() {
        return String.valueOf(this.getAlgorithmName()) + ":" + HexTools.bytesToHexString(this.getBytes());
    }
}

