/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.Digest;
import de.intarsys.tools.digest.Digester;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.provider.Providers;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigestTools {
    private static IDigestCodec codec = DigestTools.createCodec();

    protected static IDigestCodec createCodec() {
        Iterator<IDigestCodec> it = Providers.get().lookupProviders(IDigestCodec.class);
        while (it.hasNext()) {
            try {
                return it.next();
            }
            catch (Throwable t) {
                Logger.getAnonymousLogger().log(Level.WARNING, "error creating codec", t);
            }
        }
        return null;
    }

    public static IDigest createDigest(byte[] bytes) throws IOException {
        return DigestTools.decode(bytes);
    }

    public static IDigest createDigest(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof IDigest) {
            return (IDigest)value;
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return null;
            }
            value = Base64.decode((String)value);
        }
        if (value instanceof ILocator) {
            value = LocatorTools.getBytes((ILocator)value);
        }
        if (value instanceof ILocatorSupport) {
            value = LocatorTools.getBytes(((ILocatorSupport)value).getLocator());
        }
        if (value instanceof byte[]) {
            return DigestTools.decode((byte[])value);
        }
        if (value instanceof IArgs) {
            IArgs tempArgs = (IArgs)value;
            byte[] bytes = ArgTools.getByteArray(tempArgs, "der", null);
            if (bytes == null) {
                bytes = ArgTools.getByteArray(tempArgs, "raw", null);
                String hashAlgorithm = ArgTools.getString(tempArgs, "algorithm", "SHA256");
                if (bytes != null) {
                    return DigestTools.createDigest(hashAlgorithm, bytes);
                }
            } else {
                return DigestTools.decode(bytes);
            }
        }
        try {
            return ConverterRegistry.get().convert(value, IDigest.class);
        }
        catch (ConversionException e) {
            throw new IOException("can't convert " + value + " to digest");
        }
    }

    public static IDigest createDigest(String algorithmName, byte[] bytes) {
        return new Digest(algorithmName, bytes);
    }

    public static IDigester createDigester(String algorithmName) throws NoSuchAlgorithmException {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithmName, "BC");
            return new Digester(algorithmName, digest);
        }
        catch (NoSuchProviderException e) {
            MessageDigest digest = MessageDigest.getInstance(algorithmName);
            return new Digester(algorithmName, digest);
        }
    }

    public static IDigester createDigesterSHA1() {
        try {
            return DigestTools.createDigester("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA1 digest not supported");
        }
    }

    public static IDigest decode(byte[] bytes) throws IOException {
        if (DigestTools.getCodec() == null) {
            throw new IOException("no digest codec installed");
        }
        return DigestTools.getCodec().decode(bytes);
    }

    public static IDigest digest(IDigester digester, InputStream is) throws IOException {
        digester.digestUpdate(is);
        return digester.digestFinal();
    }

    protected static byte[] encode(IDigest digest) throws IOException {
        if (DigestTools.getCodec() == null) {
            throw new IOException("no digest codec installed");
        }
        return DigestTools.getCodec().encode(digest);
    }

    protected static IDigestCodec getCodec() {
        return codec;
    }

    public static interface IDigestCodec {
        public IDigest decode(byte[] var1) throws IOException;

        public byte[] encode(IDigest var1) throws IOException;
    }
}

