/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.IAttribute;
import org.w3c.dom.Attr;

public class AttributeAttributeAdapter
implements IAttribute,
IStringEvaluatorAccess {
    private final Attr attr;
    private IStringEvaluator stringEvaluator;
    private IStringEvaluator templateEvaluator;

    public AttributeAttributeAdapter(Attr attribute) {
        this.attr = attribute;
    }

    public AttributeAttributeAdapter(Attr attribute, IStringEvaluator evaluator) {
        this.attr = attribute;
        this.setStringEvaluator(evaluator);
    }

    protected Object evaluate(String value) {
        if (this.templateEvaluator == null || value == null) {
            return value;
        }
        if (value.indexOf(36) >= 0) {
            try {
                return this.templateEvaluator.evaluate(value, Args.create());
            }
            catch (Exception e) {
                return "<error expanding '" + value + "'";
            }
        }
        return value;
    }

    public Attr getAttr() {
        return this.attr;
    }

    @Override
    public Object getData() {
        return this.evaluate(this.attr.getValue());
    }

    @Override
    public String getName() {
        return this.attr.getName();
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public String getTemplate() {
        return this.attr.getValue();
    }

    @Override
    public String getValue() {
        return String.valueOf(this.evaluate(this.attr.getValue()));
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
        this.templateEvaluator = this.stringEvaluator == null ? null : TaggedStringEvaluator.decorate(evaluator);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=\"" + this.getTemplate() + "\"";
    }
}

