/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.dom.PACKAGE;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTools {
    private static final Logger Log = PACKAGE.Log;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    public static final Element[] NO_ELEMENTS;

    static {
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            Log.log(Level.WARNING, "no document builder available", e);
        }
        NO_ELEMENTS = new Element[0];
    }

    public static Document createDocument() {
        return documentBuilder.newDocument();
    }

    public static Iterator<Attr> getAttributeIterator(Element element) {
        final NamedNodeMap nodes = element.getAttributes();
        return new Iterator<Attr>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < nodes.getLength();
            }

            @Override
            public Attr next() {
                return (Attr)nodes.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int getAttrInt(Element elem, String name, int defaultValue) {
        String value = elem.getAttribute(name);
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getAttrString(Element elem, String name, String defaultValue) {
        String value = elem.getAttribute(name);
        if (StringTools.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static Element getDirectChild(Element element, String name) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            if (children.item(i).getNodeType() == 1 && name.equals((child = (Element)children.item(i)).getLocalName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static Element[] getDirectChildren(Element element) {
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return NO_ELEMENTS;
        }
        return DOMTools.toElementArray(children);
    }

    public static Element[] getDirectChildren(Element element, String name) {
        Element[] children = DOMTools.getDirectChildren(element);
        if (children.length == 0) {
            return children;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        Element[] elementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Element child = elementArray[n2];
            if (child.getLocalName().equals(name)) {
                result.add(child);
            }
            ++n2;
        }
        return ArrayTools.toArray(Element.class, result);
    }

    public static Element getElement(Element element, String name) {
        String[] segments = name.split("\\.");
        if (segments.length == 1) {
            NodeList nodes = element.getElementsByTagNameNS("*", segments[0]);
            if (nodes.getLength() == 0) {
                nodes = element.getElementsByTagName(segments[0]);
            }
            if (nodes.getLength() == 0) {
                return null;
            }
            return (Element)nodes.item(0);
        }
        int i = 0;
        while (i < segments.length) {
            if ((element = DOMTools.getElement(element, segments[i])) == null) {
                return null;
            }
            ++i;
        }
        return element;
    }

    public static Iterator<Element> getElementIterator(Element element) {
        NodeList nodes = element.getElementsByTagNameNS("*", "*");
        if (nodes.getLength() == 0) {
            nodes = element.getElementsByTagName("*");
        }
        final NodeList finalNodes = nodes;
        return new Iterator<Element>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < finalNodes.getLength();
            }

            @Override
            public Element next() {
                return (Element)finalNodes.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Element> getElementIterator(Element element, String name) {
        String[] segments = name.split("\\.");
        if (segments.length == 1) {
            NodeList nodes = element.getElementsByTagNameNS("*", segments[0]);
            if (nodes.getLength() == 0) {
                nodes = element.getElementsByTagName(segments[0]);
            }
            final NodeList finalNodes = nodes;
            return new Iterator<Element>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < finalNodes.getLength();
                }

                @Override
                public Element next() {
                    return (Element)finalNodes.item(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        int i = 0;
        while (i < segments.length - 1) {
            if ((element = DOMTools.getElement(element, segments[i])) == null) {
                return null;
            }
            ++i;
        }
        return DOMTools.getElementIterator(element, segments[segments.length - 1]);
    }

    public static Element[] getElements(Element element) {
        NodeList nodes = element.getElementsByTagNameNS("*", "*");
        if (nodes.getLength() == 0) {
            nodes = element.getElementsByTagName("*");
        }
        return DOMTools.toElementArray(nodes);
    }

    public static Element[] getElements(Element element, String name) {
        String[] segments = name.split("\\.");
        if (segments.length == 1) {
            NodeList nodes = element.getElementsByTagNameNS("*", segments[0]);
            if (nodes.getLength() == 0) {
                nodes = element.getElementsByTagName(segments[0]);
            }
            return DOMTools.toElementArray(nodes);
        }
        int i = 0;
        while (i < segments.length - 1) {
            if ((element = DOMTools.getElement(element, segments[i])) == null) {
                return null;
            }
            ++i;
        }
        return DOMTools.getElements(element, segments[segments.length - 1]);
    }

    public static Element getFirstDirectChild(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                return (Element)children.item(i);
            }
            ++i;
        }
        return null;
    }

    public static Map<String, String> getNamespaceDeclarations(Element element) {
        HashMap<String, String> namespaces = new HashMap<String, String>(10);
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            if ("xmlns".equals(node.getPrefix())) {
                String nsName = node.getLocalName();
                String nsUri = node.getTextContent();
                namespaces.put(nsName, nsUri);
            }
            ++i;
        }
        return namespaces;
    }

    public static Document parseDocument(byte[] value) throws IOException, SAXException {
        InputSource source = new InputSource(new ByteArrayInputStream(value));
        return DOMTools.parseDocument(source);
    }

    public static Document parseDocument(File file) throws IOException, SAXException {
        FileInputStream is = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(is, 10000);
        return DOMTools.parseDocument(bis, true);
    }

    protected static Document parseDocument(InputSource source) throws IOException, SAXException {
        try {
            DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
            Document doc = db.parse(source);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("parser configuration error", e);
        }
    }

    public static Document parseDocument(InputStream is, boolean close) throws IOException, SAXException {
        try {
            InputSource source = new InputSource(is);
            Document document = DOMTools.parseDocument(source);
            return document;
        }
        finally {
            if (close) {
                StreamTools.close(is);
            }
        }
    }

    public static Document parseDocument(Reader r) throws IOException, SAXException {
        InputSource source = new InputSource(r);
        return DOMTools.parseDocument(source);
    }

    public static Document parseDocument(String value) throws IOException, SAXException {
        InputSource source = new InputSource(new StringReader(value));
        return DOMTools.parseDocument(source);
    }

    public static Element parseElement(byte[] value) throws IOException, SAXException {
        return DOMTools.parseDocument(value).getDocumentElement();
    }

    public static Element parseElement(File file) throws IOException, SAXException {
        return DOMTools.parseDocument(file).getDocumentElement();
    }

    protected static Element parseElement(InputSource source) throws IOException, SAXException {
        return DOMTools.parseDocument(source).getDocumentElement();
    }

    public static Element parseElement(InputStream is, boolean close) throws IOException, SAXException {
        return DOMTools.parseDocument(is, close).getDocumentElement();
    }

    public static Element parseElement(String value) throws IOException, SAXException {
        return DOMTools.parseDocument(value).getDocumentElement();
    }

    public static Element[] toElementArray(NodeList nodes) {
        ArrayList<Element> result = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeType() == 1) {
                result.add((Element)nodes.item(i));
            }
            ++i;
        }
        return ArrayTools.toArray(Element.class, result);
    }

    private DOMTools() {
    }
}

