/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.ElementElementAdapter;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.stream.StreamTools;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentDocumentAdapter
implements IDocument,
IStringEvaluatorAccess {
    private final Document document;
    private IStringEvaluator stringEvaluator;
    private IStringEvaluator templateEvaluator;

    public DocumentDocumentAdapter(Document document) {
        this.document = document;
    }

    @Override
    public String asXML() {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
            String string = writer.toString();
            return string;
        }
        catch (TransformerException e) {
            return "<error>";
        }
        finally {
            StreamTools.close(writer);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public IElement getRootElement() {
        return new ElementElementAdapter(this.document.getDocumentElement(), this.stringEvaluator);
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public void setRootElement(IElement element) {
        Element w3cElement = ((ElementElementAdapter)element).getElement();
        Element tempElement = (Element)this.document.importNode(w3cElement, true);
        this.document.removeChild(this.document.getDocumentElement());
        this.document.appendChild(tempElement);
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
        this.templateEvaluator = this.stringEvaluator == null ? null : TaggedStringEvaluator.decorate(evaluator);
    }

    public String toString() {
        return this.asXML();
    }
}

