/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.dom.AttributeAttributeAdapter;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.stream.StreamTools;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementElementAdapter
implements IElement,
IStringEvaluatorAccess {
    private final Element element;
    private IStringEvaluator stringEvaluator;
    private IStringEvaluator templateEvaluator;

    public ElementElementAdapter(Element element) {
        this.element = element;
    }

    public ElementElementAdapter(Element element, IStringEvaluator evaluator) {
        this.element = element;
        this.setStringEvaluator(evaluator);
    }

    @Override
    public String asXML() {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.element);
            transformer.transform(source, result);
            String string = writer.toString();
            return string;
        }
        catch (TransformerException e) {
            return "<error>";
        }
        finally {
            StreamTools.close(writer);
        }
    }

    @Override
    public IAttribute attribute(String name) {
        Attr attr = this.element.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return new AttributeAttributeAdapter(attr, this.stringEvaluator);
    }

    @Override
    public Iterator<String> attributeNames() {
        return new Iterator<String>(){
            NamedNodeMap map;
            int index;
            {
                this.map = ElementElementAdapter.this.element.getAttributes();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.map.getLength();
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return ((Attr)this.map.item(this.index++)).getName();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String attributeTemplate(String name) {
        Attr attr = this.element.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public String attributeValue(String name, String defaultValue) {
        Attr attr = this.element.getAttributeNode(name);
        Object value = attr == null ? defaultValue : this.evaluate(attr.getValue());
        return value == null ? defaultValue : String.valueOf(value);
    }

    protected String condense(String pValue) {
        if (pValue == null) {
            return null;
        }
        return DirectTagReader.escape(pValue);
    }

    @Override
    public IElement element(String name) {
        NodeList list = this.element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        Element element = (Element)list.item(0);
        return new ElementElementAdapter(element, this.stringEvaluator);
    }

    @Override
    public Iterator<IElement> elementIterator() {
        Iterator<Element> it = new Iterator<Element>(){
            NodeList list;
            int index;
            {
                this.list = ElementElementAdapter.this.element.getElementsByTagName("*");
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.list.getLength();
            }

            @Override
            public Element next() {
                if (this.hasNext()) {
                    return (Element)this.list.item(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new ConversionIterator<Element, IElement>((Iterator)it){

            @Override
            protected IElement createTargetObject(Element element) {
                return new ElementElementAdapter(element, ElementElementAdapter.this.stringEvaluator);
            }
        };
    }

    @Override
    public Iterator<IElement> elementIterator(String name) {
        Iterator<Element> it = new Iterator<Element>(name){
            NodeList list;
            int index;
            {
                this.list = ElementElementAdapter.this.element.getElementsByTagName(string);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.list.getLength();
            }

            @Override
            public Element next() {
                if (this.hasNext()) {
                    return (Element)this.list.item(this.index++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new ConversionIterator<Element, IElement>((Iterator)it){

            @Override
            protected IElement createTargetObject(Element element) {
                return new ElementElementAdapter(element, ElementElementAdapter.this.stringEvaluator);
            }
        };
    }

    @Override
    public void elementRemove(IElement pElement) {
        this.element.removeChild(((ElementElementAdapter)pElement).getElement());
    }

    @Override
    public void elementsClear() {
        NodeList list = this.element.getElementsByTagName("*");
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            this.element.removeChild(node);
            ++i;
        }
    }

    @Override
    public String elementText(String name) {
        NodeList list = this.element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        Element element = (Element)list.item(0);
        Object value = this.evaluate(element.getTextContent());
        return value == null ? null : String.valueOf(value);
    }

    protected Object evaluate(String value) {
        if (this.templateEvaluator == null || value == null) {
            return value;
        }
        if (value.indexOf(36) >= 0) {
            try {
                return this.templateEvaluator.evaluate(value, Args.create());
            }
            catch (Exception e) {
                return "<error expanding '" + value + "'";
            }
        }
        return value;
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public String getText() {
        Object value = this.evaluate(this.element.getTextContent());
        return value == null ? null : String.valueOf(value);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    @Override
    public boolean hasAttributes() {
        return this.element.hasAttributes();
    }

    @Override
    public boolean hasElements() {
        return this.element.getElementsByTagName("*").getLength() > 0;
    }

    @Override
    public boolean hasElements(String name) {
        return this.element.getElementsByTagName(name).getLength() > 0;
    }

    protected Element myElement() {
        return this.element;
    }

    @Override
    public IElement newElement(String name) {
        Element tempElement = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(tempElement);
        return new ElementElementAdapter(tempElement, this.stringEvaluator);
    }

    @Override
    public void setAttributeTemplate(String name, String template) {
        if (template == null) {
            this.element.removeAttribute(name);
        } else {
            this.element.setAttribute(name, template);
        }
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (value == null) {
            this.element.removeAttribute(name);
        } else {
            this.element.setAttribute(name, this.condense(value));
        }
    }

    @Override
    public void setName(String name) {
        this.element.getOwnerDocument().renameNode(this.element, null, name);
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
        this.templateEvaluator = this.stringEvaluator == null ? null : TaggedStringEvaluator.decorate(evaluator);
    }

    @Override
    public void setText(String value) {
        this.element.setTextContent(value);
    }

    public String toString() {
        return this.asXML();
    }
}

