/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.CanonicalFromEnumItemConverter;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.message.Message;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumItem
implements Comparable {
    private static final Map META;
    protected static int WEIGHT;
    private String iconName;
    private final String id;
    private Object label;
    private final int weight;
    private final EnumMeta<EnumItem> meta;

    static {
        new CanonicalFromEnumItemConverter();
        META = new HashMap();
        WEIGHT = 0;
    }

    protected static EnumMeta getMeta(Class clazz) {
        EnumMeta result = (EnumMeta)META.get(clazz);
        if (result == null) {
            result = new EnumMeta(clazz);
            META.put(clazz, result);
        }
        return result;
    }

    protected EnumItem(EnumMeta pMeta, String pId, Object pLabel, int pWeight) {
        this.meta = pMeta;
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
        this.weight = pWeight;
    }

    protected EnumItem(String pId) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = new Message(this, this.id);
        this.weight = WEIGHT++;
    }

    protected EnumItem(String pId, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = new Message(this, this.id);
        this.weight = pWeight;
    }

    protected EnumItem(String pId, Message pMessage) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pMessage;
        this.weight = WEIGHT++;
    }

    protected EnumItem(String pId, Message pMessage, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pMessage;
        this.weight = pWeight;
    }

    protected EnumItem(String pId, String pLabel) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
        this.weight = WEIGHT++;
    }

    protected EnumItem(String pId, String pLabel, int pWeight) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = pId;
        this.label = pLabel;
        this.weight = pWeight;
    }

    public int compareTo(Object o) {
        EnumItem other = (EnumItem)o;
        return this.getWeight() - other.getWeight();
    }

    protected String getDefaultLabel() {
        return this.id;
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label instanceof Message) {
            this.label = ((Message)this.label).get();
        }
        return (String)this.label;
    }

    public String getLocalizedLabel() {
        return this.getLabel();
    }

    protected EnumMeta getMeta() {
        return this.meta;
    }

    public String getTip() {
        return this.getLabel();
    }

    protected int getWeight() {
        return this.weight;
    }

    protected void setDefault() {
        this.getMeta().setDefault(this);
    }

    protected void setIconName(String iconName) {
        this.iconName = iconName;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.getLabel();
    }
}

